/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.gamelift.model.Player;

@SdkInternalApi
public class PlayerMarshaller {
    private static final MarshallingInfo<String> PLAYERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlayerId").build();
    private static final MarshallingInfo<Map> PLAYERATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlayerAttributes").build();
    private static final MarshallingInfo<String> TEAM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Team").build();
    private static final MarshallingInfo<Map> LATENCYINMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LatencyInMs").build();
    private static final PlayerMarshaller INSTANCE = new PlayerMarshaller();

    public static PlayerMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Player player, ProtocolMarshaller protocolMarshaller) {
        if (player == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)player.playerId(), PLAYERID_BINDING);
            protocolMarshaller.marshall(player.playerAttributes(), PLAYERATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)player.team(), TEAM_BINDING);
            protocolMarshaller.marshall(player.latencyInMs(), LATENCYINMS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

