/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.gamelift.model.PlayerSessionCreationPolicy;
import software.amazon.awssdk.services.gamelift.model.ProtectionPolicy;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateGameSessionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateGameSessionRequest> {
    private final String gameSessionId;
    private final Integer maximumPlayerSessionCount;
    private final String name;
    private final String playerSessionCreationPolicy;
    private final String protectionPolicy;

    private UpdateGameSessionRequest(BuilderImpl builder) {
        this.gameSessionId = builder.gameSessionId;
        this.maximumPlayerSessionCount = builder.maximumPlayerSessionCount;
        this.name = builder.name;
        this.playerSessionCreationPolicy = builder.playerSessionCreationPolicy;
        this.protectionPolicy = builder.protectionPolicy;
    }

    public String gameSessionId() {
        return this.gameSessionId;
    }

    public Integer maximumPlayerSessionCount() {
        return this.maximumPlayerSessionCount;
    }

    public String name() {
        return this.name;
    }

    public PlayerSessionCreationPolicy playerSessionCreationPolicy() {
        return PlayerSessionCreationPolicy.fromValue(this.playerSessionCreationPolicy);
    }

    public String playerSessionCreationPolicyString() {
        return this.playerSessionCreationPolicy;
    }

    public ProtectionPolicy protectionPolicy() {
        return ProtectionPolicy.fromValue(this.protectionPolicy);
    }

    public String protectionPolicyString() {
        return this.protectionPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumPlayerSessionCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.playerSessionCreationPolicyString());
        hashCode = 31 * hashCode + Objects.hashCode(this.protectionPolicyString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGameSessionRequest)) {
            return false;
        }
        UpdateGameSessionRequest other = (UpdateGameSessionRequest)((Object)obj);
        return Objects.equals(this.gameSessionId(), other.gameSessionId()) && Objects.equals(this.maximumPlayerSessionCount(), other.maximumPlayerSessionCount()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.playerSessionCreationPolicyString(), other.playerSessionCreationPolicyString()) && Objects.equals(this.protectionPolicyString(), other.protectionPolicyString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.gameSessionId() != null) {
            sb.append("GameSessionId: ").append(this.gameSessionId()).append(",");
        }
        if (this.maximumPlayerSessionCount() != null) {
            sb.append("MaximumPlayerSessionCount: ").append(this.maximumPlayerSessionCount()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.playerSessionCreationPolicyString() != null) {
            sb.append("PlayerSessionCreationPolicy: ").append(this.playerSessionCreationPolicyString()).append(",");
        }
        if (this.protectionPolicyString() != null) {
            sb.append("ProtectionPolicy: ").append(this.protectionPolicyString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameSessionId": {
                return Optional.of(clazz.cast(this.gameSessionId()));
            }
            case "MaximumPlayerSessionCount": {
                return Optional.of(clazz.cast(this.maximumPlayerSessionCount()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "PlayerSessionCreationPolicy": {
                return Optional.of(clazz.cast(this.playerSessionCreationPolicyString()));
            }
            case "ProtectionPolicy": {
                return Optional.of(clazz.cast(this.protectionPolicyString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String gameSessionId;
        private Integer maximumPlayerSessionCount;
        private String name;
        private String playerSessionCreationPolicy;
        private String protectionPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGameSessionRequest model) {
            this.gameSessionId(model.gameSessionId);
            this.maximumPlayerSessionCount(model.maximumPlayerSessionCount);
            this.name(model.name);
            this.playerSessionCreationPolicy(model.playerSessionCreationPolicy);
            this.protectionPolicy(model.protectionPolicy);
        }

        public final String getGameSessionId() {
            return this.gameSessionId;
        }

        @Override
        public final Builder gameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
            return this;
        }

        public final void setGameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
        }

        public final Integer getMaximumPlayerSessionCount() {
            return this.maximumPlayerSessionCount;
        }

        @Override
        public final Builder maximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
            return this;
        }

        public final void setMaximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getPlayerSessionCreationPolicy() {
            return this.playerSessionCreationPolicy;
        }

        @Override
        public final Builder playerSessionCreationPolicy(String playerSessionCreationPolicy) {
            this.playerSessionCreationPolicy = playerSessionCreationPolicy;
            return this;
        }

        @Override
        public final Builder playerSessionCreationPolicy(PlayerSessionCreationPolicy playerSessionCreationPolicy) {
            this.playerSessionCreationPolicy(playerSessionCreationPolicy.toString());
            return this;
        }

        public final void setPlayerSessionCreationPolicy(String playerSessionCreationPolicy) {
            this.playerSessionCreationPolicy = playerSessionCreationPolicy;
        }

        public final String getProtectionPolicy() {
            return this.protectionPolicy;
        }

        @Override
        public final Builder protectionPolicy(String protectionPolicy) {
            this.protectionPolicy = protectionPolicy;
            return this;
        }

        @Override
        public final Builder protectionPolicy(ProtectionPolicy protectionPolicy) {
            this.protectionPolicy(protectionPolicy.toString());
            return this;
        }

        public final void setProtectionPolicy(String protectionPolicy) {
            this.protectionPolicy = protectionPolicy;
        }

        public UpdateGameSessionRequest build() {
            return new UpdateGameSessionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateGameSessionRequest> {
        public Builder gameSessionId(String var1);

        public Builder maximumPlayerSessionCount(Integer var1);

        public Builder name(String var1);

        public Builder playerSessionCreationPolicy(String var1);

        public Builder playerSessionCreationPolicy(PlayerSessionCreationPolicy var1);

        public Builder protectionPolicy(String var1);

        public Builder protectionPolicy(ProtectionPolicy var1);
    }
}

