/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.gamelift.model.MatchmakingTicket;
import software.amazon.awssdk.services.gamelift.model.MatchmakingTicketListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeMatchmakingResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeMatchmakingResponse> {
    private final List<MatchmakingTicket> ticketList;

    private DescribeMatchmakingResponse(BuilderImpl builder) {
        this.ticketList = builder.ticketList;
    }

    public List<MatchmakingTicket> ticketList() {
        return this.ticketList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ticketList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMatchmakingResponse)) {
            return false;
        }
        DescribeMatchmakingResponse other = (DescribeMatchmakingResponse)((Object)obj);
        return Objects.equals(this.ticketList(), other.ticketList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.ticketList() != null) {
            sb.append("TicketList: ").append(this.ticketList()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TicketList": {
                return Optional.of(clazz.cast(this.ticketList()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<MatchmakingTicket> ticketList;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMatchmakingResponse model) {
            this.ticketList(model.ticketList);
        }

        public final Collection<MatchmakingTicket.Builder> getTicketList() {
            return this.ticketList != null ? (Collection)this.ticketList.stream().map(MatchmakingTicket::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ticketList(Collection<MatchmakingTicket> ticketList) {
            this.ticketList = MatchmakingTicketListCopier.copy(ticketList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ticketList(MatchmakingTicket ... ticketList) {
            this.ticketList(Arrays.asList(ticketList));
            return this;
        }

        public final void setTicketList(Collection<MatchmakingTicket.BuilderImpl> ticketList) {
            this.ticketList = MatchmakingTicketListCopier.copyFromBuilder(ticketList);
        }

        public DescribeMatchmakingResponse build() {
            return new DescribeMatchmakingResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeMatchmakingResponse> {
        public Builder ticketList(Collection<MatchmakingTicket> var1);

        public Builder ticketList(MatchmakingTicket ... var1);
    }
}

