/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.gamelift.model.GameSessionDetail;
import software.amazon.awssdk.services.gamelift.model.GameSessionDetailListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeGameSessionDetailsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeGameSessionDetailsResponse> {
    private final List<GameSessionDetail> gameSessionDetails;
    private final String nextToken;

    private DescribeGameSessionDetailsResponse(BuilderImpl builder) {
        this.gameSessionDetails = builder.gameSessionDetails;
        this.nextToken = builder.nextToken;
    }

    public List<GameSessionDetail> gameSessionDetails() {
        return this.gameSessionDetails;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGameSessionDetailsResponse)) {
            return false;
        }
        DescribeGameSessionDetailsResponse other = (DescribeGameSessionDetailsResponse)((Object)obj);
        return Objects.equals(this.gameSessionDetails(), other.gameSessionDetails()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.gameSessionDetails() != null) {
            sb.append("GameSessionDetails: ").append(this.gameSessionDetails()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameSessionDetails": {
                return Optional.of(clazz.cast(this.gameSessionDetails()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<GameSessionDetail> gameSessionDetails;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGameSessionDetailsResponse model) {
            this.gameSessionDetails(model.gameSessionDetails);
            this.nextToken(model.nextToken);
        }

        public final Collection<GameSessionDetail.Builder> getGameSessionDetails() {
            return this.gameSessionDetails != null ? (Collection)this.gameSessionDetails.stream().map(GameSessionDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder gameSessionDetails(Collection<GameSessionDetail> gameSessionDetails) {
            this.gameSessionDetails = GameSessionDetailListCopier.copy(gameSessionDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameSessionDetails(GameSessionDetail ... gameSessionDetails) {
            this.gameSessionDetails(Arrays.asList(gameSessionDetails));
            return this;
        }

        public final void setGameSessionDetails(Collection<GameSessionDetail.BuilderImpl> gameSessionDetails) {
            this.gameSessionDetails = GameSessionDetailListCopier.copyFromBuilder(gameSessionDetails);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeGameSessionDetailsResponse build() {
            return new DescribeGameSessionDetailsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeGameSessionDetailsResponse> {
        public Builder gameSessionDetails(Collection<GameSessionDetail> var1);

        public Builder gameSessionDetails(GameSessionDetail ... var1);

        public Builder nextToken(String var1);
    }
}

