/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.gamelift.model.EC2InstanceType;
import software.amazon.awssdk.services.gamelift.model.IpPermission;
import software.amazon.awssdk.services.gamelift.model.IpPermissionsListCopier;
import software.amazon.awssdk.services.gamelift.model.MetricGroupListCopier;
import software.amazon.awssdk.services.gamelift.model.ProtectionPolicy;
import software.amazon.awssdk.services.gamelift.model.ResourceCreationLimitPolicy;
import software.amazon.awssdk.services.gamelift.model.RuntimeConfiguration;
import software.amazon.awssdk.services.gamelift.model.StringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateFleetRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateFleetRequest> {
    private final String name;
    private final String description;
    private final String buildId;
    private final String serverLaunchPath;
    private final String serverLaunchParameters;
    private final List<String> logPaths;
    private final String ec2InstanceType;
    private final List<IpPermission> ec2InboundPermissions;
    private final String newGameSessionProtectionPolicy;
    private final RuntimeConfiguration runtimeConfiguration;
    private final ResourceCreationLimitPolicy resourceCreationLimitPolicy;
    private final List<String> metricGroups;
    private final String peerVpcAwsAccountId;
    private final String peerVpcId;

    private CreateFleetRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.buildId = builder.buildId;
        this.serverLaunchPath = builder.serverLaunchPath;
        this.serverLaunchParameters = builder.serverLaunchParameters;
        this.logPaths = builder.logPaths;
        this.ec2InstanceType = builder.ec2InstanceType;
        this.ec2InboundPermissions = builder.ec2InboundPermissions;
        this.newGameSessionProtectionPolicy = builder.newGameSessionProtectionPolicy;
        this.runtimeConfiguration = builder.runtimeConfiguration;
        this.resourceCreationLimitPolicy = builder.resourceCreationLimitPolicy;
        this.metricGroups = builder.metricGroups;
        this.peerVpcAwsAccountId = builder.peerVpcAwsAccountId;
        this.peerVpcId = builder.peerVpcId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String buildId() {
        return this.buildId;
    }

    public String serverLaunchPath() {
        return this.serverLaunchPath;
    }

    public String serverLaunchParameters() {
        return this.serverLaunchParameters;
    }

    public List<String> logPaths() {
        return this.logPaths;
    }

    public EC2InstanceType ec2InstanceType() {
        return EC2InstanceType.fromValue(this.ec2InstanceType);
    }

    public String ec2InstanceTypeString() {
        return this.ec2InstanceType;
    }

    public List<IpPermission> ec2InboundPermissions() {
        return this.ec2InboundPermissions;
    }

    public ProtectionPolicy newGameSessionProtectionPolicy() {
        return ProtectionPolicy.fromValue(this.newGameSessionProtectionPolicy);
    }

    public String newGameSessionProtectionPolicyString() {
        return this.newGameSessionProtectionPolicy;
    }

    public RuntimeConfiguration runtimeConfiguration() {
        return this.runtimeConfiguration;
    }

    public ResourceCreationLimitPolicy resourceCreationLimitPolicy() {
        return this.resourceCreationLimitPolicy;
    }

    public List<String> metricGroups() {
        return this.metricGroups;
    }

    public String peerVpcAwsAccountId() {
        return this.peerVpcAwsAccountId;
    }

    public String peerVpcId() {
        return this.peerVpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverLaunchPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverLaunchParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.logPaths());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2InstanceTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2InboundPermissions());
        hashCode = 31 * hashCode + Objects.hashCode(this.newGameSessionProtectionPolicyString());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCreationLimitPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerVpcAwsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerVpcId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFleetRequest)) {
            return false;
        }
        CreateFleetRequest other = (CreateFleetRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.buildId(), other.buildId()) && Objects.equals(this.serverLaunchPath(), other.serverLaunchPath()) && Objects.equals(this.serverLaunchParameters(), other.serverLaunchParameters()) && Objects.equals(this.logPaths(), other.logPaths()) && Objects.equals(this.ec2InstanceTypeString(), other.ec2InstanceTypeString()) && Objects.equals(this.ec2InboundPermissions(), other.ec2InboundPermissions()) && Objects.equals(this.newGameSessionProtectionPolicyString(), other.newGameSessionProtectionPolicyString()) && Objects.equals(this.runtimeConfiguration(), other.runtimeConfiguration()) && Objects.equals(this.resourceCreationLimitPolicy(), other.resourceCreationLimitPolicy()) && Objects.equals(this.metricGroups(), other.metricGroups()) && Objects.equals(this.peerVpcAwsAccountId(), other.peerVpcAwsAccountId()) && Objects.equals(this.peerVpcId(), other.peerVpcId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.buildId() != null) {
            sb.append("BuildId: ").append(this.buildId()).append(",");
        }
        if (this.serverLaunchPath() != null) {
            sb.append("ServerLaunchPath: ").append(this.serverLaunchPath()).append(",");
        }
        if (this.serverLaunchParameters() != null) {
            sb.append("ServerLaunchParameters: ").append(this.serverLaunchParameters()).append(",");
        }
        if (this.logPaths() != null) {
            sb.append("LogPaths: ").append(this.logPaths()).append(",");
        }
        if (this.ec2InstanceTypeString() != null) {
            sb.append("EC2InstanceType: ").append(this.ec2InstanceTypeString()).append(",");
        }
        if (this.ec2InboundPermissions() != null) {
            sb.append("EC2InboundPermissions: ").append(this.ec2InboundPermissions()).append(",");
        }
        if (this.newGameSessionProtectionPolicyString() != null) {
            sb.append("NewGameSessionProtectionPolicy: ").append(this.newGameSessionProtectionPolicyString()).append(",");
        }
        if (this.runtimeConfiguration() != null) {
            sb.append("RuntimeConfiguration: ").append(this.runtimeConfiguration()).append(",");
        }
        if (this.resourceCreationLimitPolicy() != null) {
            sb.append("ResourceCreationLimitPolicy: ").append(this.resourceCreationLimitPolicy()).append(",");
        }
        if (this.metricGroups() != null) {
            sb.append("MetricGroups: ").append(this.metricGroups()).append(",");
        }
        if (this.peerVpcAwsAccountId() != null) {
            sb.append("PeerVpcAwsAccountId: ").append(this.peerVpcAwsAccountId()).append(",");
        }
        if (this.peerVpcId() != null) {
            sb.append("PeerVpcId: ").append(this.peerVpcId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "BuildId": {
                return Optional.of(clazz.cast(this.buildId()));
            }
            case "ServerLaunchPath": {
                return Optional.of(clazz.cast(this.serverLaunchPath()));
            }
            case "ServerLaunchParameters": {
                return Optional.of(clazz.cast(this.serverLaunchParameters()));
            }
            case "LogPaths": {
                return Optional.of(clazz.cast(this.logPaths()));
            }
            case "EC2InstanceType": {
                return Optional.of(clazz.cast(this.ec2InstanceTypeString()));
            }
            case "EC2InboundPermissions": {
                return Optional.of(clazz.cast(this.ec2InboundPermissions()));
            }
            case "NewGameSessionProtectionPolicy": {
                return Optional.of(clazz.cast(this.newGameSessionProtectionPolicyString()));
            }
            case "RuntimeConfiguration": {
                return Optional.of(clazz.cast(this.runtimeConfiguration()));
            }
            case "ResourceCreationLimitPolicy": {
                return Optional.of(clazz.cast(this.resourceCreationLimitPolicy()));
            }
            case "MetricGroups": {
                return Optional.of(clazz.cast(this.metricGroups()));
            }
            case "PeerVpcAwsAccountId": {
                return Optional.of(clazz.cast(this.peerVpcAwsAccountId()));
            }
            case "PeerVpcId": {
                return Optional.of(clazz.cast(this.peerVpcId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String buildId;
        private String serverLaunchPath;
        private String serverLaunchParameters;
        private List<String> logPaths;
        private String ec2InstanceType;
        private List<IpPermission> ec2InboundPermissions;
        private String newGameSessionProtectionPolicy;
        private RuntimeConfiguration runtimeConfiguration;
        private ResourceCreationLimitPolicy resourceCreationLimitPolicy;
        private List<String> metricGroups;
        private String peerVpcAwsAccountId;
        private String peerVpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFleetRequest model) {
            this.name(model.name);
            this.description(model.description);
            this.buildId(model.buildId);
            this.serverLaunchPath(model.serverLaunchPath);
            this.serverLaunchParameters(model.serverLaunchParameters);
            this.logPaths(model.logPaths);
            this.ec2InstanceType(model.ec2InstanceType);
            this.ec2InboundPermissions(model.ec2InboundPermissions);
            this.newGameSessionProtectionPolicy(model.newGameSessionProtectionPolicy);
            this.runtimeConfiguration(model.runtimeConfiguration);
            this.resourceCreationLimitPolicy(model.resourceCreationLimitPolicy);
            this.metricGroups(model.metricGroups);
            this.peerVpcAwsAccountId(model.peerVpcAwsAccountId);
            this.peerVpcId(model.peerVpcId);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getBuildId() {
            return this.buildId;
        }

        @Override
        public final Builder buildId(String buildId) {
            this.buildId = buildId;
            return this;
        }

        public final void setBuildId(String buildId) {
            this.buildId = buildId;
        }

        public final String getServerLaunchPath() {
            return this.serverLaunchPath;
        }

        @Override
        public final Builder serverLaunchPath(String serverLaunchPath) {
            this.serverLaunchPath = serverLaunchPath;
            return this;
        }

        public final void setServerLaunchPath(String serverLaunchPath) {
            this.serverLaunchPath = serverLaunchPath;
        }

        public final String getServerLaunchParameters() {
            return this.serverLaunchParameters;
        }

        @Override
        public final Builder serverLaunchParameters(String serverLaunchParameters) {
            this.serverLaunchParameters = serverLaunchParameters;
            return this;
        }

        public final void setServerLaunchParameters(String serverLaunchParameters) {
            this.serverLaunchParameters = serverLaunchParameters;
        }

        public final Collection<String> getLogPaths() {
            return this.logPaths;
        }

        @Override
        public final Builder logPaths(Collection<String> logPaths) {
            this.logPaths = StringListCopier.copy(logPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logPaths(String ... logPaths) {
            this.logPaths(Arrays.asList(logPaths));
            return this;
        }

        public final void setLogPaths(Collection<String> logPaths) {
            this.logPaths = StringListCopier.copy(logPaths);
        }

        public final String getEC2InstanceType() {
            return this.ec2InstanceType;
        }

        @Override
        public final Builder ec2InstanceType(String ec2InstanceType) {
            this.ec2InstanceType = ec2InstanceType;
            return this;
        }

        @Override
        public final Builder ec2InstanceType(EC2InstanceType ec2InstanceType) {
            this.ec2InstanceType(ec2InstanceType.toString());
            return this;
        }

        public final void setEC2InstanceType(String ec2InstanceType) {
            this.ec2InstanceType = ec2InstanceType;
        }

        public final Collection<IpPermission.Builder> getEC2InboundPermissions() {
            return this.ec2InboundPermissions != null ? (Collection)this.ec2InboundPermissions.stream().map(IpPermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ec2InboundPermissions(Collection<IpPermission> ec2InboundPermissions) {
            this.ec2InboundPermissions = IpPermissionsListCopier.copy(ec2InboundPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InboundPermissions(IpPermission ... ec2InboundPermissions) {
            this.ec2InboundPermissions(Arrays.asList(ec2InboundPermissions));
            return this;
        }

        public final void setEC2InboundPermissions(Collection<IpPermission.BuilderImpl> ec2InboundPermissions) {
            this.ec2InboundPermissions = IpPermissionsListCopier.copyFromBuilder(ec2InboundPermissions);
        }

        public final String getNewGameSessionProtectionPolicy() {
            return this.newGameSessionProtectionPolicy;
        }

        @Override
        public final Builder newGameSessionProtectionPolicy(String newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy = newGameSessionProtectionPolicy;
            return this;
        }

        @Override
        public final Builder newGameSessionProtectionPolicy(ProtectionPolicy newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy(newGameSessionProtectionPolicy.toString());
            return this;
        }

        public final void setNewGameSessionProtectionPolicy(String newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy = newGameSessionProtectionPolicy;
        }

        public final RuntimeConfiguration.Builder getRuntimeConfiguration() {
            return this.runtimeConfiguration != null ? this.runtimeConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder runtimeConfiguration(RuntimeConfiguration runtimeConfiguration) {
            this.runtimeConfiguration = runtimeConfiguration;
            return this;
        }

        public final void setRuntimeConfiguration(RuntimeConfiguration.BuilderImpl runtimeConfiguration) {
            this.runtimeConfiguration = runtimeConfiguration != null ? runtimeConfiguration.build() : null;
        }

        public final ResourceCreationLimitPolicy.Builder getResourceCreationLimitPolicy() {
            return this.resourceCreationLimitPolicy != null ? this.resourceCreationLimitPolicy.toBuilder() : null;
        }

        @Override
        public final Builder resourceCreationLimitPolicy(ResourceCreationLimitPolicy resourceCreationLimitPolicy) {
            this.resourceCreationLimitPolicy = resourceCreationLimitPolicy;
            return this;
        }

        public final void setResourceCreationLimitPolicy(ResourceCreationLimitPolicy.BuilderImpl resourceCreationLimitPolicy) {
            this.resourceCreationLimitPolicy = resourceCreationLimitPolicy != null ? resourceCreationLimitPolicy.build() : null;
        }

        public final Collection<String> getMetricGroups() {
            return this.metricGroups;
        }

        @Override
        public final Builder metricGroups(Collection<String> metricGroups) {
            this.metricGroups = MetricGroupListCopier.copy(metricGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricGroups(String ... metricGroups) {
            this.metricGroups(Arrays.asList(metricGroups));
            return this;
        }

        public final void setMetricGroups(Collection<String> metricGroups) {
            this.metricGroups = MetricGroupListCopier.copy(metricGroups);
        }

        public final String getPeerVpcAwsAccountId() {
            return this.peerVpcAwsAccountId;
        }

        @Override
        public final Builder peerVpcAwsAccountId(String peerVpcAwsAccountId) {
            this.peerVpcAwsAccountId = peerVpcAwsAccountId;
            return this;
        }

        public final void setPeerVpcAwsAccountId(String peerVpcAwsAccountId) {
            this.peerVpcAwsAccountId = peerVpcAwsAccountId;
        }

        public final String getPeerVpcId() {
            return this.peerVpcId;
        }

        @Override
        public final Builder peerVpcId(String peerVpcId) {
            this.peerVpcId = peerVpcId;
            return this;
        }

        public final void setPeerVpcId(String peerVpcId) {
            this.peerVpcId = peerVpcId;
        }

        public CreateFleetRequest build() {
            return new CreateFleetRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateFleetRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder buildId(String var1);

        public Builder serverLaunchPath(String var1);

        public Builder serverLaunchParameters(String var1);

        public Builder logPaths(Collection<String> var1);

        public Builder logPaths(String ... var1);

        public Builder ec2InstanceType(String var1);

        public Builder ec2InstanceType(EC2InstanceType var1);

        public Builder ec2InboundPermissions(Collection<IpPermission> var1);

        public Builder ec2InboundPermissions(IpPermission ... var1);

        public Builder newGameSessionProtectionPolicy(String var1);

        public Builder newGameSessionProtectionPolicy(ProtectionPolicy var1);

        public Builder runtimeConfiguration(RuntimeConfiguration var1);

        default public Builder runtimeConfiguration(Consumer<RuntimeConfiguration.Builder> runtimeConfiguration) {
            return this.runtimeConfiguration((RuntimeConfiguration)((RuntimeConfiguration.Builder)RuntimeConfiguration.builder().apply(runtimeConfiguration)).build());
        }

        public Builder resourceCreationLimitPolicy(ResourceCreationLimitPolicy var1);

        default public Builder resourceCreationLimitPolicy(Consumer<ResourceCreationLimitPolicy.Builder> resourceCreationLimitPolicy) {
            return this.resourceCreationLimitPolicy((ResourceCreationLimitPolicy)((ResourceCreationLimitPolicy.Builder)ResourceCreationLimitPolicy.builder().apply(resourceCreationLimitPolicy)).build());
        }

        public Builder metricGroups(Collection<String> var1);

        public Builder metricGroups(String ... var1);

        public Builder peerVpcAwsAccountId(String var1);

        public Builder peerVpcId(String var1);
    }
}

