/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.gamelift.model.PlacedPlayerSession;

@SdkInternalApi
public class PlacedPlayerSessionMarshaller {
    private static final MarshallingInfo<String> PLAYERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlayerId").build();
    private static final MarshallingInfo<String> PLAYERSESSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlayerSessionId").build();
    private static final PlacedPlayerSessionMarshaller INSTANCE = new PlacedPlayerSessionMarshaller();

    public static PlacedPlayerSessionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PlacedPlayerSession placedPlayerSession, ProtocolMarshaller protocolMarshaller) {
        if (placedPlayerSession == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)placedPlayerSession.playerId(), PLAYERID_BINDING);
            protocolMarshaller.marshall((Object)placedPlayerSession.playerSessionId(), PLAYERSESSIONID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

