/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.gamelift.model.Event;

@SdkInternalApi
public class EventMarshaller {
    private static final MarshallingInfo<String> EVENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventId").build();
    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceId").build();
    private static final MarshallingInfo<String> EVENTCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventCode").build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Message").build();
    private static final MarshallingInfo<Instant> EVENTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventTime").build();
    private static final EventMarshaller INSTANCE = new EventMarshaller();

    public static EventMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Event event, ProtocolMarshaller protocolMarshaller) {
        if (event == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)event.eventId(), EVENTID_BINDING);
            protocolMarshaller.marshall((Object)event.resourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall((Object)event.eventCodeString(), EVENTCODE_BINDING);
            protocolMarshaller.marshall((Object)event.message(), MESSAGE_BINDING);
            protocolMarshaller.marshall((Object)event.eventTime(), EVENTTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

