/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.gamelift.model.RuntimeConfiguration;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateRuntimeConfigurationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateRuntimeConfigurationRequest> {
    private final String fleetId;
    private final RuntimeConfiguration runtimeConfiguration;

    private UpdateRuntimeConfigurationRequest(BuilderImpl builder) {
        this.fleetId = builder.fleetId;
        this.runtimeConfiguration = builder.runtimeConfiguration;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public RuntimeConfiguration runtimeConfiguration() {
        return this.runtimeConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.fleetId() == null ? 0 : this.fleetId().hashCode());
        hashCode = 31 * hashCode + (this.runtimeConfiguration() == null ? 0 : this.runtimeConfiguration().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRuntimeConfigurationRequest)) {
            return false;
        }
        UpdateRuntimeConfigurationRequest other = (UpdateRuntimeConfigurationRequest)((Object)obj);
        if (other.fleetId() == null ^ this.fleetId() == null) {
            return false;
        }
        if (other.fleetId() != null && !other.fleetId().equals(this.fleetId())) {
            return false;
        }
        if (other.runtimeConfiguration() == null ^ this.runtimeConfiguration() == null) {
            return false;
        }
        return other.runtimeConfiguration() == null || other.runtimeConfiguration().equals(this.runtimeConfiguration());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.fleetId() != null) {
            sb.append("FleetId: ").append(this.fleetId()).append(",");
        }
        if (this.runtimeConfiguration() != null) {
            sb.append("RuntimeConfiguration: ").append(this.runtimeConfiguration()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.of(clazz.cast(this.fleetId()));
            }
            case "RuntimeConfiguration": {
                return Optional.of(clazz.cast(this.runtimeConfiguration()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String fleetId;
        private RuntimeConfiguration runtimeConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRuntimeConfigurationRequest model) {
            this.fleetId(model.fleetId);
            this.runtimeConfiguration(model.runtimeConfiguration);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final RuntimeConfiguration.Builder getRuntimeConfiguration() {
            return this.runtimeConfiguration != null ? this.runtimeConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder runtimeConfiguration(RuntimeConfiguration runtimeConfiguration) {
            this.runtimeConfiguration = runtimeConfiguration;
            return this;
        }

        public final void setRuntimeConfiguration(RuntimeConfiguration.BuilderImpl runtimeConfiguration) {
            this.runtimeConfiguration = runtimeConfiguration != null ? runtimeConfiguration.build() : null;
        }

        public UpdateRuntimeConfigurationRequest build() {
            return new UpdateRuntimeConfigurationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateRuntimeConfigurationRequest> {
        public Builder fleetId(String var1);

        public Builder runtimeConfiguration(RuntimeConfiguration var1);
    }
}

