/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.model.GameProperty;
import software.amazon.awssdk.services.gamelift.model.GamePropertyListCopier;
import software.amazon.awssdk.services.gamelift.model.GameSessionStatus;
import software.amazon.awssdk.services.gamelift.model.PlayerSessionCreationPolicy;
import software.amazon.awssdk.services.gamelift.transform.GameSessionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GameSession
implements StructuredPojo,
ToCopyableBuilder<Builder, GameSession> {
    private final String gameSessionId;
    private final String name;
    private final String fleetId;
    private final Instant creationTime;
    private final Instant terminationTime;
    private final Integer currentPlayerSessionCount;
    private final Integer maximumPlayerSessionCount;
    private final String status;
    private final List<GameProperty> gameProperties;
    private final String ipAddress;
    private final Integer port;
    private final String playerSessionCreationPolicy;
    private final String creatorId;

    private GameSession(BuilderImpl builder) {
        this.gameSessionId = builder.gameSessionId;
        this.name = builder.name;
        this.fleetId = builder.fleetId;
        this.creationTime = builder.creationTime;
        this.terminationTime = builder.terminationTime;
        this.currentPlayerSessionCount = builder.currentPlayerSessionCount;
        this.maximumPlayerSessionCount = builder.maximumPlayerSessionCount;
        this.status = builder.status;
        this.gameProperties = builder.gameProperties;
        this.ipAddress = builder.ipAddress;
        this.port = builder.port;
        this.playerSessionCreationPolicy = builder.playerSessionCreationPolicy;
        this.creatorId = builder.creatorId;
    }

    public String gameSessionId() {
        return this.gameSessionId;
    }

    public String name() {
        return this.name;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant terminationTime() {
        return this.terminationTime;
    }

    public Integer currentPlayerSessionCount() {
        return this.currentPlayerSessionCount;
    }

    public Integer maximumPlayerSessionCount() {
        return this.maximumPlayerSessionCount;
    }

    public GameSessionStatus status() {
        return GameSessionStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public List<GameProperty> gameProperties() {
        return this.gameProperties;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public Integer port() {
        return this.port;
    }

    public PlayerSessionCreationPolicy playerSessionCreationPolicy() {
        return PlayerSessionCreationPolicy.fromValue(this.playerSessionCreationPolicy);
    }

    public String playerSessionCreationPolicyString() {
        return this.playerSessionCreationPolicy;
    }

    public String creatorId() {
        return this.creatorId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.gameSessionId() == null ? 0 : this.gameSessionId().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.fleetId() == null ? 0 : this.fleetId().hashCode());
        hashCode = 31 * hashCode + (this.creationTime() == null ? 0 : this.creationTime().hashCode());
        hashCode = 31 * hashCode + (this.terminationTime() == null ? 0 : this.terminationTime().hashCode());
        hashCode = 31 * hashCode + (this.currentPlayerSessionCount() == null ? 0 : this.currentPlayerSessionCount().hashCode());
        hashCode = 31 * hashCode + (this.maximumPlayerSessionCount() == null ? 0 : this.maximumPlayerSessionCount().hashCode());
        hashCode = 31 * hashCode + (this.statusString() == null ? 0 : this.statusString().hashCode());
        hashCode = 31 * hashCode + (this.gameProperties() == null ? 0 : this.gameProperties().hashCode());
        hashCode = 31 * hashCode + (this.ipAddress() == null ? 0 : this.ipAddress().hashCode());
        hashCode = 31 * hashCode + (this.port() == null ? 0 : this.port().hashCode());
        hashCode = 31 * hashCode + (this.playerSessionCreationPolicyString() == null ? 0 : this.playerSessionCreationPolicyString().hashCode());
        hashCode = 31 * hashCode + (this.creatorId() == null ? 0 : this.creatorId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GameSession)) {
            return false;
        }
        GameSession other = (GameSession)obj;
        if (other.gameSessionId() == null ^ this.gameSessionId() == null) {
            return false;
        }
        if (other.gameSessionId() != null && !other.gameSessionId().equals(this.gameSessionId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.fleetId() == null ^ this.fleetId() == null) {
            return false;
        }
        if (other.fleetId() != null && !other.fleetId().equals(this.fleetId())) {
            return false;
        }
        if (other.creationTime() == null ^ this.creationTime() == null) {
            return false;
        }
        if (other.creationTime() != null && !other.creationTime().equals(this.creationTime())) {
            return false;
        }
        if (other.terminationTime() == null ^ this.terminationTime() == null) {
            return false;
        }
        if (other.terminationTime() != null && !other.terminationTime().equals(this.terminationTime())) {
            return false;
        }
        if (other.currentPlayerSessionCount() == null ^ this.currentPlayerSessionCount() == null) {
            return false;
        }
        if (other.currentPlayerSessionCount() != null && !other.currentPlayerSessionCount().equals(this.currentPlayerSessionCount())) {
            return false;
        }
        if (other.maximumPlayerSessionCount() == null ^ this.maximumPlayerSessionCount() == null) {
            return false;
        }
        if (other.maximumPlayerSessionCount() != null && !other.maximumPlayerSessionCount().equals(this.maximumPlayerSessionCount())) {
            return false;
        }
        if (other.statusString() == null ^ this.statusString() == null) {
            return false;
        }
        if (other.statusString() != null && !other.statusString().equals(this.statusString())) {
            return false;
        }
        if (other.gameProperties() == null ^ this.gameProperties() == null) {
            return false;
        }
        if (other.gameProperties() != null && !other.gameProperties().equals(this.gameProperties())) {
            return false;
        }
        if (other.ipAddress() == null ^ this.ipAddress() == null) {
            return false;
        }
        if (other.ipAddress() != null && !other.ipAddress().equals(this.ipAddress())) {
            return false;
        }
        if (other.port() == null ^ this.port() == null) {
            return false;
        }
        if (other.port() != null && !other.port().equals(this.port())) {
            return false;
        }
        if (other.playerSessionCreationPolicyString() == null ^ this.playerSessionCreationPolicyString() == null) {
            return false;
        }
        if (other.playerSessionCreationPolicyString() != null && !other.playerSessionCreationPolicyString().equals(this.playerSessionCreationPolicyString())) {
            return false;
        }
        if (other.creatorId() == null ^ this.creatorId() == null) {
            return false;
        }
        return other.creatorId() == null || other.creatorId().equals(this.creatorId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.gameSessionId() != null) {
            sb.append("GameSessionId: ").append(this.gameSessionId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.fleetId() != null) {
            sb.append("FleetId: ").append(this.fleetId()).append(",");
        }
        if (this.creationTime() != null) {
            sb.append("CreationTime: ").append(this.creationTime()).append(",");
        }
        if (this.terminationTime() != null) {
            sb.append("TerminationTime: ").append(this.terminationTime()).append(",");
        }
        if (this.currentPlayerSessionCount() != null) {
            sb.append("CurrentPlayerSessionCount: ").append(this.currentPlayerSessionCount()).append(",");
        }
        if (this.maximumPlayerSessionCount() != null) {
            sb.append("MaximumPlayerSessionCount: ").append(this.maximumPlayerSessionCount()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.gameProperties() != null) {
            sb.append("GameProperties: ").append(this.gameProperties()).append(",");
        }
        if (this.ipAddress() != null) {
            sb.append("IpAddress: ").append(this.ipAddress()).append(",");
        }
        if (this.port() != null) {
            sb.append("Port: ").append(this.port()).append(",");
        }
        if (this.playerSessionCreationPolicyString() != null) {
            sb.append("PlayerSessionCreationPolicy: ").append(this.playerSessionCreationPolicyString()).append(",");
        }
        if (this.creatorId() != null) {
            sb.append("CreatorId: ").append(this.creatorId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameSessionId": {
                return Optional.of(clazz.cast(this.gameSessionId()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "FleetId": {
                return Optional.of(clazz.cast(this.fleetId()));
            }
            case "CreationTime": {
                return Optional.of(clazz.cast(this.creationTime()));
            }
            case "TerminationTime": {
                return Optional.of(clazz.cast(this.terminationTime()));
            }
            case "CurrentPlayerSessionCount": {
                return Optional.of(clazz.cast(this.currentPlayerSessionCount()));
            }
            case "MaximumPlayerSessionCount": {
                return Optional.of(clazz.cast(this.maximumPlayerSessionCount()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "GameProperties": {
                return Optional.of(clazz.cast(this.gameProperties()));
            }
            case "IpAddress": {
                return Optional.of(clazz.cast(this.ipAddress()));
            }
            case "Port": {
                return Optional.of(clazz.cast(this.port()));
            }
            case "PlayerSessionCreationPolicy": {
                return Optional.of(clazz.cast(this.playerSessionCreationPolicyString()));
            }
            case "CreatorId": {
                return Optional.of(clazz.cast(this.creatorId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GameSessionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String gameSessionId;
        private String name;
        private String fleetId;
        private Instant creationTime;
        private Instant terminationTime;
        private Integer currentPlayerSessionCount;
        private Integer maximumPlayerSessionCount;
        private String status;
        private List<GameProperty> gameProperties;
        private String ipAddress;
        private Integer port;
        private String playerSessionCreationPolicy;
        private String creatorId;

        private BuilderImpl() {
        }

        private BuilderImpl(GameSession model) {
            this.gameSessionId(model.gameSessionId);
            this.name(model.name);
            this.fleetId(model.fleetId);
            this.creationTime(model.creationTime);
            this.terminationTime(model.terminationTime);
            this.currentPlayerSessionCount(model.currentPlayerSessionCount);
            this.maximumPlayerSessionCount(model.maximumPlayerSessionCount);
            this.status(model.status);
            this.gameProperties(model.gameProperties);
            this.ipAddress(model.ipAddress);
            this.port(model.port);
            this.playerSessionCreationPolicy(model.playerSessionCreationPolicy);
            this.creatorId(model.creatorId);
        }

        public final String getGameSessionId() {
            return this.gameSessionId;
        }

        @Override
        public final Builder gameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
            return this;
        }

        public final void setGameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getTerminationTime() {
            return this.terminationTime;
        }

        @Override
        public final Builder terminationTime(Instant terminationTime) {
            this.terminationTime = terminationTime;
            return this;
        }

        public final void setTerminationTime(Instant terminationTime) {
            this.terminationTime = terminationTime;
        }

        public final Integer getCurrentPlayerSessionCount() {
            return this.currentPlayerSessionCount;
        }

        @Override
        public final Builder currentPlayerSessionCount(Integer currentPlayerSessionCount) {
            this.currentPlayerSessionCount = currentPlayerSessionCount;
            return this;
        }

        public final void setCurrentPlayerSessionCount(Integer currentPlayerSessionCount) {
            this.currentPlayerSessionCount = currentPlayerSessionCount;
        }

        public final Integer getMaximumPlayerSessionCount() {
            return this.maximumPlayerSessionCount;
        }

        @Override
        public final Builder maximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
            return this;
        }

        public final void setMaximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GameSessionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Collection<GameProperty.Builder> getGameProperties() {
            return this.gameProperties != null ? (Collection)this.gameProperties.stream().map(GameProperty::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder gameProperties(Collection<GameProperty> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copy(gameProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameProperties(GameProperty ... gameProperties) {
            this.gameProperties(Arrays.asList(gameProperties));
            return this;
        }

        public final void setGameProperties(Collection<GameProperty.BuilderImpl> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copyFromBuilder(gameProperties);
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getPlayerSessionCreationPolicy() {
            return this.playerSessionCreationPolicy;
        }

        @Override
        public final Builder playerSessionCreationPolicy(String playerSessionCreationPolicy) {
            this.playerSessionCreationPolicy = playerSessionCreationPolicy;
            return this;
        }

        @Override
        public final Builder playerSessionCreationPolicy(PlayerSessionCreationPolicy playerSessionCreationPolicy) {
            this.playerSessionCreationPolicy(playerSessionCreationPolicy.toString());
            return this;
        }

        public final void setPlayerSessionCreationPolicy(String playerSessionCreationPolicy) {
            this.playerSessionCreationPolicy = playerSessionCreationPolicy;
        }

        public final String getCreatorId() {
            return this.creatorId;
        }

        @Override
        public final Builder creatorId(String creatorId) {
            this.creatorId = creatorId;
            return this;
        }

        public final void setCreatorId(String creatorId) {
            this.creatorId = creatorId;
        }

        public GameSession build() {
            return new GameSession(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GameSession> {
        public Builder gameSessionId(String var1);

        public Builder name(String var1);

        public Builder fleetId(String var1);

        public Builder creationTime(Instant var1);

        public Builder terminationTime(Instant var1);

        public Builder currentPlayerSessionCount(Integer var1);

        public Builder maximumPlayerSessionCount(Integer var1);

        public Builder status(String var1);

        public Builder status(GameSessionStatus var1);

        public Builder gameProperties(Collection<GameProperty> var1);

        public Builder gameProperties(GameProperty ... var1);

        public Builder ipAddress(String var1);

        public Builder port(Integer var1);

        public Builder playerSessionCreationPolicy(String var1);

        public Builder playerSessionCreationPolicy(PlayerSessionCreationPolicy var1);

        public Builder creatorId(String var1);
    }
}

