/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.model.GameProperty;
import software.amazon.awssdk.services.gamelift.model.GamePropertyListCopier;
import software.amazon.awssdk.services.gamelift.model.GameSessionPlacementState;
import software.amazon.awssdk.services.gamelift.model.PlacedPlayerSession;
import software.amazon.awssdk.services.gamelift.model.PlacedPlayerSessionListCopier;
import software.amazon.awssdk.services.gamelift.model.PlayerLatency;
import software.amazon.awssdk.services.gamelift.model.PlayerLatencyListCopier;
import software.amazon.awssdk.services.gamelift.transform.GameSessionPlacementMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GameSessionPlacement
implements StructuredPojo,
ToCopyableBuilder<Builder, GameSessionPlacement> {
    private final String placementId;
    private final String gameSessionQueueName;
    private final String status;
    private final List<GameProperty> gameProperties;
    private final Integer maximumPlayerSessionCount;
    private final String gameSessionName;
    private final String gameSessionId;
    private final String gameSessionArn;
    private final String gameSessionRegion;
    private final List<PlayerLatency> playerLatencies;
    private final Instant startTime;
    private final Instant endTime;
    private final String ipAddress;
    private final Integer port;
    private final List<PlacedPlayerSession> placedPlayerSessions;

    private GameSessionPlacement(BuilderImpl builder) {
        this.placementId = builder.placementId;
        this.gameSessionQueueName = builder.gameSessionQueueName;
        this.status = builder.status;
        this.gameProperties = builder.gameProperties;
        this.maximumPlayerSessionCount = builder.maximumPlayerSessionCount;
        this.gameSessionName = builder.gameSessionName;
        this.gameSessionId = builder.gameSessionId;
        this.gameSessionArn = builder.gameSessionArn;
        this.gameSessionRegion = builder.gameSessionRegion;
        this.playerLatencies = builder.playerLatencies;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.ipAddress = builder.ipAddress;
        this.port = builder.port;
        this.placedPlayerSessions = builder.placedPlayerSessions;
    }

    public String placementId() {
        return this.placementId;
    }

    public String gameSessionQueueName() {
        return this.gameSessionQueueName;
    }

    public String status() {
        return this.status;
    }

    public List<GameProperty> gameProperties() {
        return this.gameProperties;
    }

    public Integer maximumPlayerSessionCount() {
        return this.maximumPlayerSessionCount;
    }

    public String gameSessionName() {
        return this.gameSessionName;
    }

    public String gameSessionId() {
        return this.gameSessionId;
    }

    public String gameSessionArn() {
        return this.gameSessionArn;
    }

    public String gameSessionRegion() {
        return this.gameSessionRegion;
    }

    public List<PlayerLatency> playerLatencies() {
        return this.playerLatencies;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public Integer port() {
        return this.port;
    }

    public List<PlacedPlayerSession> placedPlayerSessions() {
        return this.placedPlayerSessions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.placementId() == null ? 0 : this.placementId().hashCode());
        hashCode = 31 * hashCode + (this.gameSessionQueueName() == null ? 0 : this.gameSessionQueueName().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.gameProperties() == null ? 0 : this.gameProperties().hashCode());
        hashCode = 31 * hashCode + (this.maximumPlayerSessionCount() == null ? 0 : this.maximumPlayerSessionCount().hashCode());
        hashCode = 31 * hashCode + (this.gameSessionName() == null ? 0 : this.gameSessionName().hashCode());
        hashCode = 31 * hashCode + (this.gameSessionId() == null ? 0 : this.gameSessionId().hashCode());
        hashCode = 31 * hashCode + (this.gameSessionArn() == null ? 0 : this.gameSessionArn().hashCode());
        hashCode = 31 * hashCode + (this.gameSessionRegion() == null ? 0 : this.gameSessionRegion().hashCode());
        hashCode = 31 * hashCode + (this.playerLatencies() == null ? 0 : this.playerLatencies().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        hashCode = 31 * hashCode + (this.endTime() == null ? 0 : this.endTime().hashCode());
        hashCode = 31 * hashCode + (this.ipAddress() == null ? 0 : this.ipAddress().hashCode());
        hashCode = 31 * hashCode + (this.port() == null ? 0 : this.port().hashCode());
        hashCode = 31 * hashCode + (this.placedPlayerSessions() == null ? 0 : this.placedPlayerSessions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GameSessionPlacement)) {
            return false;
        }
        GameSessionPlacement other = (GameSessionPlacement)obj;
        if (other.placementId() == null ^ this.placementId() == null) {
            return false;
        }
        if (other.placementId() != null && !other.placementId().equals(this.placementId())) {
            return false;
        }
        if (other.gameSessionQueueName() == null ^ this.gameSessionQueueName() == null) {
            return false;
        }
        if (other.gameSessionQueueName() != null && !other.gameSessionQueueName().equals(this.gameSessionQueueName())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.gameProperties() == null ^ this.gameProperties() == null) {
            return false;
        }
        if (other.gameProperties() != null && !other.gameProperties().equals(this.gameProperties())) {
            return false;
        }
        if (other.maximumPlayerSessionCount() == null ^ this.maximumPlayerSessionCount() == null) {
            return false;
        }
        if (other.maximumPlayerSessionCount() != null && !other.maximumPlayerSessionCount().equals(this.maximumPlayerSessionCount())) {
            return false;
        }
        if (other.gameSessionName() == null ^ this.gameSessionName() == null) {
            return false;
        }
        if (other.gameSessionName() != null && !other.gameSessionName().equals(this.gameSessionName())) {
            return false;
        }
        if (other.gameSessionId() == null ^ this.gameSessionId() == null) {
            return false;
        }
        if (other.gameSessionId() != null && !other.gameSessionId().equals(this.gameSessionId())) {
            return false;
        }
        if (other.gameSessionArn() == null ^ this.gameSessionArn() == null) {
            return false;
        }
        if (other.gameSessionArn() != null && !other.gameSessionArn().equals(this.gameSessionArn())) {
            return false;
        }
        if (other.gameSessionRegion() == null ^ this.gameSessionRegion() == null) {
            return false;
        }
        if (other.gameSessionRegion() != null && !other.gameSessionRegion().equals(this.gameSessionRegion())) {
            return false;
        }
        if (other.playerLatencies() == null ^ this.playerLatencies() == null) {
            return false;
        }
        if (other.playerLatencies() != null && !other.playerLatencies().equals(this.playerLatencies())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.ipAddress() == null ^ this.ipAddress() == null) {
            return false;
        }
        if (other.ipAddress() != null && !other.ipAddress().equals(this.ipAddress())) {
            return false;
        }
        if (other.port() == null ^ this.port() == null) {
            return false;
        }
        if (other.port() != null && !other.port().equals(this.port())) {
            return false;
        }
        if (other.placedPlayerSessions() == null ^ this.placedPlayerSessions() == null) {
            return false;
        }
        return other.placedPlayerSessions() == null || other.placedPlayerSessions().equals(this.placedPlayerSessions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.placementId() != null) {
            sb.append("PlacementId: ").append(this.placementId()).append(",");
        }
        if (this.gameSessionQueueName() != null) {
            sb.append("GameSessionQueueName: ").append(this.gameSessionQueueName()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.gameProperties() != null) {
            sb.append("GameProperties: ").append(this.gameProperties()).append(",");
        }
        if (this.maximumPlayerSessionCount() != null) {
            sb.append("MaximumPlayerSessionCount: ").append(this.maximumPlayerSessionCount()).append(",");
        }
        if (this.gameSessionName() != null) {
            sb.append("GameSessionName: ").append(this.gameSessionName()).append(",");
        }
        if (this.gameSessionId() != null) {
            sb.append("GameSessionId: ").append(this.gameSessionId()).append(",");
        }
        if (this.gameSessionArn() != null) {
            sb.append("GameSessionArn: ").append(this.gameSessionArn()).append(",");
        }
        if (this.gameSessionRegion() != null) {
            sb.append("GameSessionRegion: ").append(this.gameSessionRegion()).append(",");
        }
        if (this.playerLatencies() != null) {
            sb.append("PlayerLatencies: ").append(this.playerLatencies()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (this.ipAddress() != null) {
            sb.append("IpAddress: ").append(this.ipAddress()).append(",");
        }
        if (this.port() != null) {
            sb.append("Port: ").append(this.port()).append(",");
        }
        if (this.placedPlayerSessions() != null) {
            sb.append("PlacedPlayerSessions: ").append(this.placedPlayerSessions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GameSessionPlacementMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String placementId;
        private String gameSessionQueueName;
        private String status;
        private List<GameProperty> gameProperties;
        private Integer maximumPlayerSessionCount;
        private String gameSessionName;
        private String gameSessionId;
        private String gameSessionArn;
        private String gameSessionRegion;
        private List<PlayerLatency> playerLatencies;
        private Instant startTime;
        private Instant endTime;
        private String ipAddress;
        private Integer port;
        private List<PlacedPlayerSession> placedPlayerSessions;

        private BuilderImpl() {
        }

        private BuilderImpl(GameSessionPlacement model) {
            this.setPlacementId(model.placementId);
            this.setGameSessionQueueName(model.gameSessionQueueName);
            this.setStatus(model.status);
            this.setGameProperties(model.gameProperties);
            this.setMaximumPlayerSessionCount(model.maximumPlayerSessionCount);
            this.setGameSessionName(model.gameSessionName);
            this.setGameSessionId(model.gameSessionId);
            this.setGameSessionArn(model.gameSessionArn);
            this.setGameSessionRegion(model.gameSessionRegion);
            this.setPlayerLatencies(model.playerLatencies);
            this.setStartTime(model.startTime);
            this.setEndTime(model.endTime);
            this.setIpAddress(model.ipAddress);
            this.setPort(model.port);
            this.setPlacedPlayerSessions(model.placedPlayerSessions);
        }

        public final String getPlacementId() {
            return this.placementId;
        }

        @Override
        public final Builder placementId(String placementId) {
            this.placementId = placementId;
            return this;
        }

        public final void setPlacementId(String placementId) {
            this.placementId = placementId;
        }

        public final String getGameSessionQueueName() {
            return this.gameSessionQueueName;
        }

        @Override
        public final Builder gameSessionQueueName(String gameSessionQueueName) {
            this.gameSessionQueueName = gameSessionQueueName;
            return this;
        }

        public final void setGameSessionQueueName(String gameSessionQueueName) {
            this.gameSessionQueueName = gameSessionQueueName;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GameSessionPlacementState status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Collection<GameProperty> getGameProperties() {
            return this.gameProperties;
        }

        @Override
        public final Builder gameProperties(Collection<GameProperty> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copy(gameProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameProperties(GameProperty ... gameProperties) {
            this.gameProperties(Arrays.asList(gameProperties));
            return this;
        }

        public final void setGameProperties(Collection<GameProperty> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copy(gameProperties);
        }

        public final Integer getMaximumPlayerSessionCount() {
            return this.maximumPlayerSessionCount;
        }

        @Override
        public final Builder maximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
            return this;
        }

        public final void setMaximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
        }

        public final String getGameSessionName() {
            return this.gameSessionName;
        }

        @Override
        public final Builder gameSessionName(String gameSessionName) {
            this.gameSessionName = gameSessionName;
            return this;
        }

        public final void setGameSessionName(String gameSessionName) {
            this.gameSessionName = gameSessionName;
        }

        public final String getGameSessionId() {
            return this.gameSessionId;
        }

        @Override
        public final Builder gameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
            return this;
        }

        public final void setGameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
        }

        public final String getGameSessionArn() {
            return this.gameSessionArn;
        }

        @Override
        public final Builder gameSessionArn(String gameSessionArn) {
            this.gameSessionArn = gameSessionArn;
            return this;
        }

        public final void setGameSessionArn(String gameSessionArn) {
            this.gameSessionArn = gameSessionArn;
        }

        public final String getGameSessionRegion() {
            return this.gameSessionRegion;
        }

        @Override
        public final Builder gameSessionRegion(String gameSessionRegion) {
            this.gameSessionRegion = gameSessionRegion;
            return this;
        }

        public final void setGameSessionRegion(String gameSessionRegion) {
            this.gameSessionRegion = gameSessionRegion;
        }

        public final Collection<PlayerLatency> getPlayerLatencies() {
            return this.playerLatencies;
        }

        @Override
        public final Builder playerLatencies(Collection<PlayerLatency> playerLatencies) {
            this.playerLatencies = PlayerLatencyListCopier.copy(playerLatencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playerLatencies(PlayerLatency ... playerLatencies) {
            this.playerLatencies(Arrays.asList(playerLatencies));
            return this;
        }

        public final void setPlayerLatencies(Collection<PlayerLatency> playerLatencies) {
            this.playerLatencies = PlayerLatencyListCopier.copy(playerLatencies);
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final Collection<PlacedPlayerSession> getPlacedPlayerSessions() {
            return this.placedPlayerSessions;
        }

        @Override
        public final Builder placedPlayerSessions(Collection<PlacedPlayerSession> placedPlayerSessions) {
            this.placedPlayerSessions = PlacedPlayerSessionListCopier.copy(placedPlayerSessions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placedPlayerSessions(PlacedPlayerSession ... placedPlayerSessions) {
            this.placedPlayerSessions(Arrays.asList(placedPlayerSessions));
            return this;
        }

        public final void setPlacedPlayerSessions(Collection<PlacedPlayerSession> placedPlayerSessions) {
            this.placedPlayerSessions = PlacedPlayerSessionListCopier.copy(placedPlayerSessions);
        }

        public GameSessionPlacement build() {
            return new GameSessionPlacement(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GameSessionPlacement> {
        public Builder placementId(String var1);

        public Builder gameSessionQueueName(String var1);

        public Builder status(String var1);

        public Builder status(GameSessionPlacementState var1);

        public Builder gameProperties(Collection<GameProperty> var1);

        public Builder gameProperties(GameProperty ... var1);

        public Builder maximumPlayerSessionCount(Integer var1);

        public Builder gameSessionName(String var1);

        public Builder gameSessionId(String var1);

        public Builder gameSessionArn(String var1);

        public Builder gameSessionRegion(String var1);

        public Builder playerLatencies(Collection<PlayerLatency> var1);

        public Builder playerLatencies(PlayerLatency ... var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder ipAddress(String var1);

        public Builder port(Integer var1);

        public Builder placedPlayerSessions(Collection<PlacedPlayerSession> var1);

        public Builder placedPlayerSessions(PlacedPlayerSession ... var1);
    }
}

