/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.gamelift.model.FleetUtilization;

@SdkInternalApi
public class FleetUtilizationMarshaller {
    private static final MarshallingInfo<String> FLEETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FleetId").build();
    private static final MarshallingInfo<Integer> ACTIVESERVERPROCESSCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActiveServerProcessCount").build();
    private static final MarshallingInfo<Integer> ACTIVEGAMESESSIONCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActiveGameSessionCount").build();
    private static final MarshallingInfo<Integer> CURRENTPLAYERSESSIONCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CurrentPlayerSessionCount").build();
    private static final MarshallingInfo<Integer> MAXIMUMPLAYERSESSIONCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaximumPlayerSessionCount").build();
    private static final FleetUtilizationMarshaller INSTANCE = new FleetUtilizationMarshaller();

    public static FleetUtilizationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(FleetUtilization fleetUtilization, ProtocolMarshaller protocolMarshaller) {
        if (fleetUtilization == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)fleetUtilization.fleetId(), FLEETID_BINDING);
            protocolMarshaller.marshall((Object)fleetUtilization.activeServerProcessCount(), ACTIVESERVERPROCESSCOUNT_BINDING);
            protocolMarshaller.marshall((Object)fleetUtilization.activeGameSessionCount(), ACTIVEGAMESESSIONCOUNT_BINDING);
            protocolMarshaller.marshall((Object)fleetUtilization.currentPlayerSessionCount(), CURRENTPLAYERSESSIONCOUNT_BINDING);
            protocolMarshaller.marshall((Object)fleetUtilization.maximumPlayerSessionCount(), MAXIMUMPLAYERSESSIONCOUNT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

