/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.gamelift.model.MetricGroupListCopier;
import software.amazon.awssdk.services.gamelift.model.ProtectionPolicy;
import software.amazon.awssdk.services.gamelift.model.ResourceCreationLimitPolicy;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateFleetAttributesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateFleetAttributesRequest> {
    private final String fleetId;
    private final String name;
    private final String description;
    private final String newGameSessionProtectionPolicy;
    private final ResourceCreationLimitPolicy resourceCreationLimitPolicy;
    private final List<String> metricGroups;

    private UpdateFleetAttributesRequest(BuilderImpl builder) {
        this.fleetId = builder.fleetId;
        this.name = builder.name;
        this.description = builder.description;
        this.newGameSessionProtectionPolicy = builder.newGameSessionProtectionPolicy;
        this.resourceCreationLimitPolicy = builder.resourceCreationLimitPolicy;
        this.metricGroups = builder.metricGroups;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String newGameSessionProtectionPolicy() {
        return this.newGameSessionProtectionPolicy;
    }

    public ResourceCreationLimitPolicy resourceCreationLimitPolicy() {
        return this.resourceCreationLimitPolicy;
    }

    public List<String> metricGroups() {
        return this.metricGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.fleetId() == null ? 0 : this.fleetId().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.newGameSessionProtectionPolicy() == null ? 0 : this.newGameSessionProtectionPolicy().hashCode());
        hashCode = 31 * hashCode + (this.resourceCreationLimitPolicy() == null ? 0 : this.resourceCreationLimitPolicy().hashCode());
        hashCode = 31 * hashCode + (this.metricGroups() == null ? 0 : this.metricGroups().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFleetAttributesRequest)) {
            return false;
        }
        UpdateFleetAttributesRequest other = (UpdateFleetAttributesRequest)((Object)obj);
        if (other.fleetId() == null ^ this.fleetId() == null) {
            return false;
        }
        if (other.fleetId() != null && !other.fleetId().equals(this.fleetId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.newGameSessionProtectionPolicy() == null ^ this.newGameSessionProtectionPolicy() == null) {
            return false;
        }
        if (other.newGameSessionProtectionPolicy() != null && !other.newGameSessionProtectionPolicy().equals(this.newGameSessionProtectionPolicy())) {
            return false;
        }
        if (other.resourceCreationLimitPolicy() == null ^ this.resourceCreationLimitPolicy() == null) {
            return false;
        }
        if (other.resourceCreationLimitPolicy() != null && !other.resourceCreationLimitPolicy().equals(this.resourceCreationLimitPolicy())) {
            return false;
        }
        if (other.metricGroups() == null ^ this.metricGroups() == null) {
            return false;
        }
        return other.metricGroups() == null || other.metricGroups().equals(this.metricGroups());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fleetId() != null) {
            sb.append("FleetId: ").append(this.fleetId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.newGameSessionProtectionPolicy() != null) {
            sb.append("NewGameSessionProtectionPolicy: ").append(this.newGameSessionProtectionPolicy()).append(",");
        }
        if (this.resourceCreationLimitPolicy() != null) {
            sb.append("ResourceCreationLimitPolicy: ").append(this.resourceCreationLimitPolicy()).append(",");
        }
        if (this.metricGroups() != null) {
            sb.append("MetricGroups: ").append(this.metricGroups()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String fleetId;
        private String name;
        private String description;
        private String newGameSessionProtectionPolicy;
        private ResourceCreationLimitPolicy resourceCreationLimitPolicy;
        private List<String> metricGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFleetAttributesRequest model) {
            this.setFleetId(model.fleetId);
            this.setName(model.name);
            this.setDescription(model.description);
            this.setNewGameSessionProtectionPolicy(model.newGameSessionProtectionPolicy);
            this.setResourceCreationLimitPolicy(model.resourceCreationLimitPolicy);
            this.setMetricGroups(model.metricGroups);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getNewGameSessionProtectionPolicy() {
            return this.newGameSessionProtectionPolicy;
        }

        @Override
        public final Builder newGameSessionProtectionPolicy(String newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy = newGameSessionProtectionPolicy;
            return this;
        }

        @Override
        public final Builder newGameSessionProtectionPolicy(ProtectionPolicy newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy(newGameSessionProtectionPolicy.toString());
            return this;
        }

        public final void setNewGameSessionProtectionPolicy(String newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy = newGameSessionProtectionPolicy;
        }

        public final void setNewGameSessionProtectionPolicy(ProtectionPolicy newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy(newGameSessionProtectionPolicy.toString());
        }

        public final ResourceCreationLimitPolicy getResourceCreationLimitPolicy() {
            return this.resourceCreationLimitPolicy;
        }

        @Override
        public final Builder resourceCreationLimitPolicy(ResourceCreationLimitPolicy resourceCreationLimitPolicy) {
            this.resourceCreationLimitPolicy = resourceCreationLimitPolicy;
            return this;
        }

        public final void setResourceCreationLimitPolicy(ResourceCreationLimitPolicy resourceCreationLimitPolicy) {
            this.resourceCreationLimitPolicy = resourceCreationLimitPolicy;
        }

        public final Collection<String> getMetricGroups() {
            return this.metricGroups;
        }

        @Override
        public final Builder metricGroups(Collection<String> metricGroups) {
            this.metricGroups = MetricGroupListCopier.copy(metricGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricGroups(String ... metricGroups) {
            this.metricGroups(Arrays.asList(metricGroups));
            return this;
        }

        public final void setMetricGroups(Collection<String> metricGroups) {
            this.metricGroups = MetricGroupListCopier.copy(metricGroups);
        }

        @SafeVarargs
        public final void setMetricGroups(String ... metricGroups) {
            this.metricGroups(Arrays.asList(metricGroups));
        }

        public UpdateFleetAttributesRequest build() {
            return new UpdateFleetAttributesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateFleetAttributesRequest> {
        public Builder fleetId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder newGameSessionProtectionPolicy(String var1);

        public Builder newGameSessionProtectionPolicy(ProtectionPolicy var1);

        public Builder resourceCreationLimitPolicy(ResourceCreationLimitPolicy var1);

        public Builder metricGroups(Collection<String> var1);

        public Builder metricGroups(String ... var1);
    }
}

