/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.model.GameSessionQueueDestination;
import software.amazon.awssdk.services.gamelift.model.GameSessionQueueDestinationListCopier;
import software.amazon.awssdk.services.gamelift.model.PlayerLatencyPolicy;
import software.amazon.awssdk.services.gamelift.model.PlayerLatencyPolicyListCopier;
import software.amazon.awssdk.services.gamelift.transform.GameSessionQueueMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GameSessionQueue
implements StructuredPojo,
ToCopyableBuilder<Builder, GameSessionQueue> {
    private final String name;
    private final String gameSessionQueueArn;
    private final Integer timeoutInSeconds;
    private final List<PlayerLatencyPolicy> playerLatencyPolicies;
    private final List<GameSessionQueueDestination> destinations;

    private GameSessionQueue(BuilderImpl builder) {
        this.name = builder.name;
        this.gameSessionQueueArn = builder.gameSessionQueueArn;
        this.timeoutInSeconds = builder.timeoutInSeconds;
        this.playerLatencyPolicies = builder.playerLatencyPolicies;
        this.destinations = builder.destinations;
    }

    public String name() {
        return this.name;
    }

    public String gameSessionQueueArn() {
        return this.gameSessionQueueArn;
    }

    public Integer timeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public List<PlayerLatencyPolicy> playerLatencyPolicies() {
        return this.playerLatencyPolicies;
    }

    public List<GameSessionQueueDestination> destinations() {
        return this.destinations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.gameSessionQueueArn() == null ? 0 : this.gameSessionQueueArn().hashCode());
        hashCode = 31 * hashCode + (this.timeoutInSeconds() == null ? 0 : this.timeoutInSeconds().hashCode());
        hashCode = 31 * hashCode + (this.playerLatencyPolicies() == null ? 0 : this.playerLatencyPolicies().hashCode());
        hashCode = 31 * hashCode + (this.destinations() == null ? 0 : this.destinations().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GameSessionQueue)) {
            return false;
        }
        GameSessionQueue other = (GameSessionQueue)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.gameSessionQueueArn() == null ^ this.gameSessionQueueArn() == null) {
            return false;
        }
        if (other.gameSessionQueueArn() != null && !other.gameSessionQueueArn().equals(this.gameSessionQueueArn())) {
            return false;
        }
        if (other.timeoutInSeconds() == null ^ this.timeoutInSeconds() == null) {
            return false;
        }
        if (other.timeoutInSeconds() != null && !other.timeoutInSeconds().equals(this.timeoutInSeconds())) {
            return false;
        }
        if (other.playerLatencyPolicies() == null ^ this.playerLatencyPolicies() == null) {
            return false;
        }
        if (other.playerLatencyPolicies() != null && !other.playerLatencyPolicies().equals(this.playerLatencyPolicies())) {
            return false;
        }
        if (other.destinations() == null ^ this.destinations() == null) {
            return false;
        }
        return other.destinations() == null || other.destinations().equals(this.destinations());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.gameSessionQueueArn() != null) {
            sb.append("GameSessionQueueArn: ").append(this.gameSessionQueueArn()).append(",");
        }
        if (this.timeoutInSeconds() != null) {
            sb.append("TimeoutInSeconds: ").append(this.timeoutInSeconds()).append(",");
        }
        if (this.playerLatencyPolicies() != null) {
            sb.append("PlayerLatencyPolicies: ").append(this.playerLatencyPolicies()).append(",");
        }
        if (this.destinations() != null) {
            sb.append("Destinations: ").append(this.destinations()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GameSessionQueueMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private String gameSessionQueueArn;
        private Integer timeoutInSeconds;
        private List<PlayerLatencyPolicy> playerLatencyPolicies;
        private List<GameSessionQueueDestination> destinations;

        private BuilderImpl() {
        }

        private BuilderImpl(GameSessionQueue model) {
            this.setName(model.name);
            this.setGameSessionQueueArn(model.gameSessionQueueArn);
            this.setTimeoutInSeconds(model.timeoutInSeconds);
            this.setPlayerLatencyPolicies(model.playerLatencyPolicies);
            this.setDestinations(model.destinations);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getGameSessionQueueArn() {
            return this.gameSessionQueueArn;
        }

        @Override
        public final Builder gameSessionQueueArn(String gameSessionQueueArn) {
            this.gameSessionQueueArn = gameSessionQueueArn;
            return this;
        }

        public final void setGameSessionQueueArn(String gameSessionQueueArn) {
            this.gameSessionQueueArn = gameSessionQueueArn;
        }

        public final Integer getTimeoutInSeconds() {
            return this.timeoutInSeconds;
        }

        @Override
        public final Builder timeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            return this;
        }

        public final void setTimeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
        }

        public final Collection<PlayerLatencyPolicy> getPlayerLatencyPolicies() {
            return this.playerLatencyPolicies;
        }

        @Override
        public final Builder playerLatencyPolicies(Collection<PlayerLatencyPolicy> playerLatencyPolicies) {
            this.playerLatencyPolicies = PlayerLatencyPolicyListCopier.copy(playerLatencyPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playerLatencyPolicies(PlayerLatencyPolicy ... playerLatencyPolicies) {
            this.playerLatencyPolicies(Arrays.asList(playerLatencyPolicies));
            return this;
        }

        public final void setPlayerLatencyPolicies(Collection<PlayerLatencyPolicy> playerLatencyPolicies) {
            this.playerLatencyPolicies = PlayerLatencyPolicyListCopier.copy(playerLatencyPolicies);
        }

        @SafeVarargs
        public final void setPlayerLatencyPolicies(PlayerLatencyPolicy ... playerLatencyPolicies) {
            this.playerLatencyPolicies(Arrays.asList(playerLatencyPolicies));
        }

        public final Collection<GameSessionQueueDestination> getDestinations() {
            return this.destinations;
        }

        @Override
        public final Builder destinations(Collection<GameSessionQueueDestination> destinations) {
            this.destinations = GameSessionQueueDestinationListCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(GameSessionQueueDestination ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        public final void setDestinations(Collection<GameSessionQueueDestination> destinations) {
            this.destinations = GameSessionQueueDestinationListCopier.copy(destinations);
        }

        @SafeVarargs
        public final void setDestinations(GameSessionQueueDestination ... destinations) {
            this.destinations(Arrays.asList(destinations));
        }

        public GameSessionQueue build() {
            return new GameSessionQueue(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GameSessionQueue> {
        public Builder name(String var1);

        public Builder gameSessionQueueArn(String var1);

        public Builder timeoutInSeconds(Integer var1);

        public Builder playerLatencyPolicies(Collection<PlayerLatencyPolicy> var1);

        public Builder playerLatencyPolicies(PlayerLatencyPolicy ... var1);

        public Builder destinations(Collection<GameSessionQueueDestination> var1);

        public Builder destinations(GameSessionQueueDestination ... var1);
    }
}

