/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.gamelift.model.GameSessionQueue;
import software.amazon.awssdk.services.gamelift.model.GameSessionQueueListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeGameSessionQueuesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeGameSessionQueuesResponse> {
    private final List<GameSessionQueue> gameSessionQueues;
    private final String nextToken;

    private DescribeGameSessionQueuesResponse(BuilderImpl builder) {
        this.gameSessionQueues = builder.gameSessionQueues;
        this.nextToken = builder.nextToken;
    }

    public List<GameSessionQueue> gameSessionQueues() {
        return this.gameSessionQueues;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.gameSessionQueues() == null ? 0 : this.gameSessionQueues().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGameSessionQueuesResponse)) {
            return false;
        }
        DescribeGameSessionQueuesResponse other = (DescribeGameSessionQueuesResponse)((Object)obj);
        if (other.gameSessionQueues() == null ^ this.gameSessionQueues() == null) {
            return false;
        }
        if (other.gameSessionQueues() != null && !other.gameSessionQueues().equals(this.gameSessionQueues())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.gameSessionQueues() != null) {
            sb.append("GameSessionQueues: ").append(this.gameSessionQueues()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<GameSessionQueue> gameSessionQueues;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGameSessionQueuesResponse model) {
            this.setGameSessionQueues(model.gameSessionQueues);
            this.setNextToken(model.nextToken);
        }

        public final Collection<GameSessionQueue> getGameSessionQueues() {
            return this.gameSessionQueues;
        }

        @Override
        public final Builder gameSessionQueues(Collection<GameSessionQueue> gameSessionQueues) {
            this.gameSessionQueues = GameSessionQueueListCopier.copy(gameSessionQueues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameSessionQueues(GameSessionQueue ... gameSessionQueues) {
            this.gameSessionQueues(Arrays.asList(gameSessionQueues));
            return this;
        }

        public final void setGameSessionQueues(Collection<GameSessionQueue> gameSessionQueues) {
            this.gameSessionQueues = GameSessionQueueListCopier.copy(gameSessionQueues);
        }

        @SafeVarargs
        public final void setGameSessionQueues(GameSessionQueue ... gameSessionQueues) {
            this.gameSessionQueues(Arrays.asList(gameSessionQueues));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeGameSessionQueuesResponse build() {
            return new DescribeGameSessionQueuesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeGameSessionQueuesResponse> {
        public Builder gameSessionQueues(Collection<GameSessionQueue> var1);

        public Builder gameSessionQueues(GameSessionQueue ... var1);

        public Builder nextToken(String var1);
    }
}

