/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.gamelift.model.GameSessionQueueNameListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeGameSessionQueuesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeGameSessionQueuesRequest> {
    private final List<String> names;
    private final Integer limit;
    private final String nextToken;

    private DescribeGameSessionQueuesRequest(BuilderImpl builder) {
        this.names = builder.names;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    public List<String> names() {
        return this.names;
    }

    public Integer limit() {
        return this.limit;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.names() == null ? 0 : this.names().hashCode());
        hashCode = 31 * hashCode + (this.limit() == null ? 0 : this.limit().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGameSessionQueuesRequest)) {
            return false;
        }
        DescribeGameSessionQueuesRequest other = (DescribeGameSessionQueuesRequest)((Object)obj);
        if (other.names() == null ^ this.names() == null) {
            return false;
        }
        if (other.names() != null && !other.names().equals(this.names())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        if (other.limit() != null && !other.limit().equals(this.limit())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.names() != null) {
            sb.append("Names: ").append(this.names()).append(",");
        }
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> names;
        private Integer limit;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGameSessionQueuesRequest model) {
            this.setNames(model.names);
            this.setLimit(model.limit);
            this.setNextToken(model.nextToken);
        }

        public final Collection<String> getNames() {
            return this.names;
        }

        @Override
        public final Builder names(Collection<String> names) {
            this.names = GameSessionQueueNameListCopier.copy(names);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(String ... names) {
            this.names(Arrays.asList(names));
            return this;
        }

        public final void setNames(Collection<String> names) {
            this.names = GameSessionQueueNameListCopier.copy(names);
        }

        @SafeVarargs
        public final void setNames(String ... names) {
            this.names(Arrays.asList(names));
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeGameSessionQueuesRequest build() {
            return new DescribeGameSessionQueuesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeGameSessionQueuesRequest> {
        public Builder names(Collection<String> var1);

        public Builder names(String ... var1);

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);
    }
}

