/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.gamelift.model.GameProperty;
import software.amazon.awssdk.services.gamelift.model.GamePropertyListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateGameSessionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateGameSessionRequest> {
    private final String fleetId;
    private final String aliasId;
    private final Integer maximumPlayerSessionCount;
    private final String name;
    private final List<GameProperty> gameProperties;
    private final String creatorId;
    private final String gameSessionId;
    private final String idempotencyToken;

    private CreateGameSessionRequest(BuilderImpl builder) {
        this.fleetId = builder.fleetId;
        this.aliasId = builder.aliasId;
        this.maximumPlayerSessionCount = builder.maximumPlayerSessionCount;
        this.name = builder.name;
        this.gameProperties = builder.gameProperties;
        this.creatorId = builder.creatorId;
        this.gameSessionId = builder.gameSessionId;
        this.idempotencyToken = builder.idempotencyToken;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public String aliasId() {
        return this.aliasId;
    }

    public Integer maximumPlayerSessionCount() {
        return this.maximumPlayerSessionCount;
    }

    public String name() {
        return this.name;
    }

    public List<GameProperty> gameProperties() {
        return this.gameProperties;
    }

    public String creatorId() {
        return this.creatorId;
    }

    public String gameSessionId() {
        return this.gameSessionId;
    }

    public String idempotencyToken() {
        return this.idempotencyToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.fleetId() == null ? 0 : this.fleetId().hashCode());
        hashCode = 31 * hashCode + (this.aliasId() == null ? 0 : this.aliasId().hashCode());
        hashCode = 31 * hashCode + (this.maximumPlayerSessionCount() == null ? 0 : this.maximumPlayerSessionCount().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.gameProperties() == null ? 0 : this.gameProperties().hashCode());
        hashCode = 31 * hashCode + (this.creatorId() == null ? 0 : this.creatorId().hashCode());
        hashCode = 31 * hashCode + (this.gameSessionId() == null ? 0 : this.gameSessionId().hashCode());
        hashCode = 31 * hashCode + (this.idempotencyToken() == null ? 0 : this.idempotencyToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGameSessionRequest)) {
            return false;
        }
        CreateGameSessionRequest other = (CreateGameSessionRequest)((Object)obj);
        if (other.fleetId() == null ^ this.fleetId() == null) {
            return false;
        }
        if (other.fleetId() != null && !other.fleetId().equals(this.fleetId())) {
            return false;
        }
        if (other.aliasId() == null ^ this.aliasId() == null) {
            return false;
        }
        if (other.aliasId() != null && !other.aliasId().equals(this.aliasId())) {
            return false;
        }
        if (other.maximumPlayerSessionCount() == null ^ this.maximumPlayerSessionCount() == null) {
            return false;
        }
        if (other.maximumPlayerSessionCount() != null && !other.maximumPlayerSessionCount().equals(this.maximumPlayerSessionCount())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.gameProperties() == null ^ this.gameProperties() == null) {
            return false;
        }
        if (other.gameProperties() != null && !other.gameProperties().equals(this.gameProperties())) {
            return false;
        }
        if (other.creatorId() == null ^ this.creatorId() == null) {
            return false;
        }
        if (other.creatorId() != null && !other.creatorId().equals(this.creatorId())) {
            return false;
        }
        if (other.gameSessionId() == null ^ this.gameSessionId() == null) {
            return false;
        }
        if (other.gameSessionId() != null && !other.gameSessionId().equals(this.gameSessionId())) {
            return false;
        }
        if (other.idempotencyToken() == null ^ this.idempotencyToken() == null) {
            return false;
        }
        return other.idempotencyToken() == null || other.idempotencyToken().equals(this.idempotencyToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fleetId() != null) {
            sb.append("FleetId: ").append(this.fleetId()).append(",");
        }
        if (this.aliasId() != null) {
            sb.append("AliasId: ").append(this.aliasId()).append(",");
        }
        if (this.maximumPlayerSessionCount() != null) {
            sb.append("MaximumPlayerSessionCount: ").append(this.maximumPlayerSessionCount()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.gameProperties() != null) {
            sb.append("GameProperties: ").append(this.gameProperties()).append(",");
        }
        if (this.creatorId() != null) {
            sb.append("CreatorId: ").append(this.creatorId()).append(",");
        }
        if (this.gameSessionId() != null) {
            sb.append("GameSessionId: ").append(this.gameSessionId()).append(",");
        }
        if (this.idempotencyToken() != null) {
            sb.append("IdempotencyToken: ").append(this.idempotencyToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String fleetId;
        private String aliasId;
        private Integer maximumPlayerSessionCount;
        private String name;
        private List<GameProperty> gameProperties;
        private String creatorId;
        private String gameSessionId;
        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGameSessionRequest model) {
            this.setFleetId(model.fleetId);
            this.setAliasId(model.aliasId);
            this.setMaximumPlayerSessionCount(model.maximumPlayerSessionCount);
            this.setName(model.name);
            this.setGameProperties(model.gameProperties);
            this.setCreatorId(model.creatorId);
            this.setGameSessionId(model.gameSessionId);
            this.setIdempotencyToken(model.idempotencyToken);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final String getAliasId() {
            return this.aliasId;
        }

        @Override
        public final Builder aliasId(String aliasId) {
            this.aliasId = aliasId;
            return this;
        }

        public final void setAliasId(String aliasId) {
            this.aliasId = aliasId;
        }

        public final Integer getMaximumPlayerSessionCount() {
            return this.maximumPlayerSessionCount;
        }

        @Override
        public final Builder maximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
            return this;
        }

        public final void setMaximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<GameProperty> getGameProperties() {
            return this.gameProperties;
        }

        @Override
        public final Builder gameProperties(Collection<GameProperty> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copy(gameProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameProperties(GameProperty ... gameProperties) {
            this.gameProperties(Arrays.asList(gameProperties));
            return this;
        }

        public final void setGameProperties(Collection<GameProperty> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copy(gameProperties);
        }

        @SafeVarargs
        public final void setGameProperties(GameProperty ... gameProperties) {
            this.gameProperties(Arrays.asList(gameProperties));
        }

        public final String getCreatorId() {
            return this.creatorId;
        }

        @Override
        public final Builder creatorId(String creatorId) {
            this.creatorId = creatorId;
            return this;
        }

        public final void setCreatorId(String creatorId) {
            this.creatorId = creatorId;
        }

        public final String getGameSessionId() {
            return this.gameSessionId;
        }

        @Override
        public final Builder gameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
            return this;
        }

        public final void setGameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        public CreateGameSessionRequest build() {
            return new CreateGameSessionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateGameSessionRequest> {
        public Builder fleetId(String var1);

        public Builder aliasId(String var1);

        public Builder maximumPlayerSessionCount(Integer var1);

        public Builder name(String var1);

        public Builder gameProperties(Collection<GameProperty> var1);

        public Builder gameProperties(GameProperty ... var1);

        public Builder creatorId(String var1);

        public Builder gameSessionId(String var1);

        public Builder idempotencyToken(String var1);
    }
}

