/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.gamelift.model.TargetConfiguration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TargetConfigurationMarshaller {
    private static final MarshallingInfo<Double> TARGETVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetValue").isBinary(false).build();
    private static final TargetConfigurationMarshaller INSTANCE = new TargetConfigurationMarshaller();

    private TargetConfigurationMarshaller() {
    }

    public static TargetConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TargetConfiguration targetConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)targetConfiguration, (String)"targetConfiguration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)targetConfiguration.targetValue(), TARGETVALUE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

