/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.gamelift.model.DescribeInstancesRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribeInstancesRequestModelMarshaller {
    private static final MarshallingInfo<String> FLEETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FleetId").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").isBinary(false).build();
    private static final MarshallingInfo<Integer> LIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Limit").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").isBinary(false).build();
    private static final DescribeInstancesRequestModelMarshaller INSTANCE = new DescribeInstancesRequestModelMarshaller();

    private DescribeInstancesRequestModelMarshaller() {
    }

    public static DescribeInstancesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DescribeInstancesRequest describeInstancesRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)describeInstancesRequest), (String)"describeInstancesRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)describeInstancesRequest.fleetId(), FLEETID_BINDING);
            protocolMarshaller.marshall((Object)describeInstancesRequest.instanceId(), INSTANCEID_BINDING);
            protocolMarshaller.marshall((Object)describeInstancesRequest.limit(), LIMIT_BINDING);
            protocolMarshaller.marshall((Object)describeInstancesRequest.nextToken(), NEXTTOKEN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

