/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.gamelift.model.FleetUtilization;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class FleetUtilizationMarshaller {
    private static final MarshallingInfo<String> FLEETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FleetId").isBinary(false).build();
    private static final MarshallingInfo<Integer> ACTIVESERVERPROCESSCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActiveServerProcessCount").isBinary(false).build();
    private static final MarshallingInfo<Integer> ACTIVEGAMESESSIONCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActiveGameSessionCount").isBinary(false).build();
    private static final MarshallingInfo<Integer> CURRENTPLAYERSESSIONCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CurrentPlayerSessionCount").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXIMUMPLAYERSESSIONCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaximumPlayerSessionCount").isBinary(false).build();
    private static final FleetUtilizationMarshaller INSTANCE = new FleetUtilizationMarshaller();

    private FleetUtilizationMarshaller() {
    }

    public static FleetUtilizationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(FleetUtilization fleetUtilization, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)fleetUtilization, (String)"fleetUtilization");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)fleetUtilization.fleetId(), FLEETID_BINDING);
            protocolMarshaller.marshall((Object)fleetUtilization.activeServerProcessCount(), ACTIVESERVERPROCESSCOUNT_BINDING);
            protocolMarshaller.marshall((Object)fleetUtilization.activeGameSessionCount(), ACTIVEGAMESESSIONCOUNT_BINDING);
            protocolMarshaller.marshall((Object)fleetUtilization.currentPlayerSessionCount(), CURRENTPLAYERSESSIONCOUNT_BINDING);
            protocolMarshaller.marshall((Object)fleetUtilization.maximumPlayerSessionCount(), MAXIMUMPLAYERSESSIONCOUNT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

