/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreatePlayerSessionRequestModelMarshaller {
    private static final MarshallingInfo<String> GAMESESSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GameSessionId").isBinary(false).build();
    private static final MarshallingInfo<String> PLAYERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlayerId").isBinary(false).build();
    private static final MarshallingInfo<String> PLAYERDATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlayerData").isBinary(false).build();
    private static final CreatePlayerSessionRequestModelMarshaller INSTANCE = new CreatePlayerSessionRequestModelMarshaller();

    private CreatePlayerSessionRequestModelMarshaller() {
    }

    public static CreatePlayerSessionRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreatePlayerSessionRequest createPlayerSessionRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createPlayerSessionRequest), (String)"createPlayerSessionRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createPlayerSessionRequest.gameSessionId(), GAMESESSIONID_BINDING);
            protocolMarshaller.marshall((Object)createPlayerSessionRequest.playerId(), PLAYERID_BINDING);
            protocolMarshaller.marshall((Object)createPlayerSessionRequest.playerData(), PLAYERDATA_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

