/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.model.Alias;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AliasMarshaller {
    private static final MarshallingInfo<String> ALIASID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AliasId").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> ALIASARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AliasArn").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ROUTINGSTRATEGY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoutingStrategy").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTUPDATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdatedTime").isBinary(false).build();
    private static final AliasMarshaller INSTANCE = new AliasMarshaller();

    private AliasMarshaller() {
    }

    public static AliasMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Alias alias, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)alias, (String)"alias");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)alias.aliasId(), ALIASID_BINDING);
            protocolMarshaller.marshall((Object)alias.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)alias.aliasArn(), ALIASARN_BINDING);
            protocolMarshaller.marshall((Object)alias.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)alias.routingStrategy(), ROUTINGSTRATEGY_BINDING);
            protocolMarshaller.marshall((Object)alias.creationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)alias.lastUpdatedTime(), LASTUPDATEDTIME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

