/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePlayerSessionsRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, DescribePlayerSessionsRequest> {
    private final String gameSessionId;
    private final String playerId;
    private final String playerSessionId;
    private final String playerSessionStatusFilter;
    private final Integer limit;
    private final String nextToken;

    private DescribePlayerSessionsRequest(BuilderImpl builder) {
        super(builder);
        this.gameSessionId = builder.gameSessionId;
        this.playerId = builder.playerId;
        this.playerSessionId = builder.playerSessionId;
        this.playerSessionStatusFilter = builder.playerSessionStatusFilter;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    public String gameSessionId() {
        return this.gameSessionId;
    }

    public String playerId() {
        return this.playerId;
    }

    public String playerSessionId() {
        return this.playerSessionId;
    }

    public String playerSessionStatusFilter() {
        return this.playerSessionStatusFilter;
    }

    public Integer limit() {
        return this.limit;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.playerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.playerSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.playerSessionStatusFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePlayerSessionsRequest)) {
            return false;
        }
        DescribePlayerSessionsRequest other = (DescribePlayerSessionsRequest)((Object)obj);
        return Objects.equals(this.gameSessionId(), other.gameSessionId()) && Objects.equals(this.playerId(), other.playerId()) && Objects.equals(this.playerSessionId(), other.playerSessionId()) && Objects.equals(this.playerSessionStatusFilter(), other.playerSessionStatusFilter()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribePlayerSessionsRequest").add("GameSessionId", (Object)this.gameSessionId()).add("PlayerId", (Object)this.playerId()).add("PlayerSessionId", (Object)this.playerSessionId()).add("PlayerSessionStatusFilter", (Object)this.playerSessionStatusFilter()).add("Limit", (Object)this.limit()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameSessionId": {
                return Optional.ofNullable(clazz.cast(this.gameSessionId()));
            }
            case "PlayerId": {
                return Optional.ofNullable(clazz.cast(this.playerId()));
            }
            case "PlayerSessionId": {
                return Optional.ofNullable(clazz.cast(this.playerSessionId()));
            }
            case "PlayerSessionStatusFilter": {
                return Optional.ofNullable(clazz.cast(this.playerSessionStatusFilter()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String gameSessionId;
        private String playerId;
        private String playerSessionId;
        private String playerSessionStatusFilter;
        private Integer limit;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePlayerSessionsRequest model) {
            super(model);
            this.gameSessionId(model.gameSessionId);
            this.playerId(model.playerId);
            this.playerSessionId(model.playerSessionId);
            this.playerSessionStatusFilter(model.playerSessionStatusFilter);
            this.limit(model.limit);
            this.nextToken(model.nextToken);
        }

        public final String getGameSessionId() {
            return this.gameSessionId;
        }

        @Override
        public final Builder gameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
            return this;
        }

        public final void setGameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
        }

        public final String getPlayerId() {
            return this.playerId;
        }

        @Override
        public final Builder playerId(String playerId) {
            this.playerId = playerId;
            return this;
        }

        public final void setPlayerId(String playerId) {
            this.playerId = playerId;
        }

        public final String getPlayerSessionId() {
            return this.playerSessionId;
        }

        @Override
        public final Builder playerSessionId(String playerSessionId) {
            this.playerSessionId = playerSessionId;
            return this;
        }

        public final void setPlayerSessionId(String playerSessionId) {
            this.playerSessionId = playerSessionId;
        }

        public final String getPlayerSessionStatusFilter() {
            return this.playerSessionStatusFilter;
        }

        @Override
        public final Builder playerSessionStatusFilter(String playerSessionStatusFilter) {
            this.playerSessionStatusFilter = playerSessionStatusFilter;
            return this;
        }

        public final void setPlayerSessionStatusFilter(String playerSessionStatusFilter) {
            this.playerSessionStatusFilter = playerSessionStatusFilter;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribePlayerSessionsRequest build() {
            return new DescribePlayerSessionsRequest(this);
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    CopyableBuilder<Builder, DescribePlayerSessionsRequest> {
        public Builder gameSessionId(String var1);

        public Builder playerId(String var1);

        public Builder playerSessionId(String var1);

        public Builder playerSessionStatusFilter(String var1);

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

