/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.services.gamelift.model.MatchmakingConfiguration;
import software.amazon.awssdk.services.gamelift.model.MatchmakingConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMatchmakingConfigurationsResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, DescribeMatchmakingConfigurationsResponse> {
    private final List<MatchmakingConfiguration> configurations;
    private final String nextToken;

    private DescribeMatchmakingConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.configurations = builder.configurations;
        this.nextToken = builder.nextToken;
    }

    public List<MatchmakingConfiguration> configurations() {
        return this.configurations;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configurations());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMatchmakingConfigurationsResponse)) {
            return false;
        }
        DescribeMatchmakingConfigurationsResponse other = (DescribeMatchmakingConfigurationsResponse)((Object)obj);
        return Objects.equals(this.configurations(), other.configurations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeMatchmakingConfigurationsResponse").add("Configurations", this.configurations()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Configurations": {
                return Optional.ofNullable(clazz.cast(this.configurations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private List<MatchmakingConfiguration> configurations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMatchmakingConfigurationsResponse model) {
            super(model);
            this.configurations(model.configurations);
            this.nextToken(model.nextToken);
        }

        public final Collection<MatchmakingConfiguration.Builder> getConfigurations() {
            return this.configurations != null ? (Collection)this.configurations.stream().map(MatchmakingConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configurations(Collection<MatchmakingConfiguration> configurations) {
            this.configurations = MatchmakingConfigurationListCopier.copy(configurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(MatchmakingConfiguration ... configurations) {
            this.configurations(Arrays.asList(configurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Consumer<MatchmakingConfiguration.Builder> ... configurations) {
            this.configurations(Stream.of(configurations).map(c -> (MatchmakingConfiguration)((MatchmakingConfiguration.Builder)MatchmakingConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConfigurations(Collection<MatchmakingConfiguration.BuilderImpl> configurations) {
            this.configurations = MatchmakingConfigurationListCopier.copyFromBuilder(configurations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeMatchmakingConfigurationsResponse build() {
            return new DescribeMatchmakingConfigurationsResponse(this);
        }
    }

    public static interface Builder
    extends GameLiftResponse.Builder,
    CopyableBuilder<Builder, DescribeMatchmakingConfigurationsResponse> {
        public Builder configurations(Collection<MatchmakingConfiguration> var1);

        public Builder configurations(MatchmakingConfiguration ... var1);

        public Builder configurations(Consumer<MatchmakingConfiguration.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

