/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.gamelift.model.StartMatchmakingRequest;
import software.amazon.awssdk.services.gamelift.transform.StartMatchmakingRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StartMatchmakingRequestMarshaller
implements Marshaller<Request<StartMatchmakingRequest>, StartMatchmakingRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("GameLift.StartMatchmaking").serviceName("Amazon GameLift").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public StartMatchmakingRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<StartMatchmakingRequest> marshall(StartMatchmakingRequest startMatchmakingRequest) {
        Validate.paramNotNull((Object)((Object)startMatchmakingRequest), (String)"startMatchmakingRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)startMatchmakingRequest);
            protocolMarshaller.startMarshalling();
            StartMatchmakingRequestModelMarshaller.getInstance().marshall(startMatchmakingRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

