/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.model.FleetAttributes;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class FleetAttributesMarshaller {
    private static final MarshallingInfo<String> FLEETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FleetId").isBinary(false).build();
    private static final MarshallingInfo<String> FLEETARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FleetArn").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> TERMINATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TerminationTime").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<String> BUILDID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BuildId").isBinary(false).build();
    private static final MarshallingInfo<String> SERVERLAUNCHPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServerLaunchPath").isBinary(false).build();
    private static final MarshallingInfo<String> SERVERLAUNCHPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServerLaunchParameters").isBinary(false).build();
    private static final MarshallingInfo<List> LOGPATHS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogPaths").isBinary(false).build();
    private static final MarshallingInfo<String> NEWGAMESESSIONPROTECTIONPOLICY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NewGameSessionProtectionPolicy").isBinary(false).build();
    private static final MarshallingInfo<String> OPERATINGSYSTEM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OperatingSystem").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> RESOURCECREATIONLIMITPOLICY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceCreationLimitPolicy").isBinary(false).build();
    private static final MarshallingInfo<List> METRICGROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MetricGroups").isBinary(false).build();
    private static final FleetAttributesMarshaller INSTANCE = new FleetAttributesMarshaller();

    private FleetAttributesMarshaller() {
    }

    public static FleetAttributesMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(FleetAttributes fleetAttributes, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)fleetAttributes, (String)"fleetAttributes");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)fleetAttributes.fleetId(), FLEETID_BINDING);
            protocolMarshaller.marshall((Object)fleetAttributes.fleetArn(), FLEETARN_BINDING);
            protocolMarshaller.marshall((Object)fleetAttributes.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)fleetAttributes.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)fleetAttributes.creationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)fleetAttributes.terminationTime(), TERMINATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)fleetAttributes.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)fleetAttributes.buildId(), BUILDID_BINDING);
            protocolMarshaller.marshall((Object)fleetAttributes.serverLaunchPath(), SERVERLAUNCHPATH_BINDING);
            protocolMarshaller.marshall((Object)fleetAttributes.serverLaunchParameters(), SERVERLAUNCHPARAMETERS_BINDING);
            protocolMarshaller.marshall(fleetAttributes.logPaths(), LOGPATHS_BINDING);
            protocolMarshaller.marshall((Object)fleetAttributes.newGameSessionProtectionPolicyAsString(), NEWGAMESESSIONPROTECTIONPOLICY_BINDING);
            protocolMarshaller.marshall((Object)fleetAttributes.operatingSystemAsString(), OPERATINGSYSTEM_BINDING);
            protocolMarshaller.marshall((Object)fleetAttributes.resourceCreationLimitPolicy(), RESOURCECREATIONLIMITPOLICY_BINDING);
            protocolMarshaller.marshall(fleetAttributes.metricGroups(), METRICGROUPS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

