/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.gamelift.model.CreateGameSessionRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateGameSessionRequestModelMarshaller {
    private static final MarshallingInfo<String> FLEETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FleetId").isBinary(false).build();
    private static final MarshallingInfo<String> ALIASID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AliasId").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXIMUMPLAYERSESSIONCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaximumPlayerSessionCount").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<List> GAMEPROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GameProperties").isBinary(false).build();
    private static final MarshallingInfo<String> CREATORID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatorId").isBinary(false).build();
    private static final MarshallingInfo<String> GAMESESSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GameSessionId").isBinary(false).build();
    private static final MarshallingInfo<String> IDEMPOTENCYTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdempotencyToken").isBinary(false).build();
    private static final MarshallingInfo<String> GAMESESSIONDATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GameSessionData").isBinary(false).build();
    private static final CreateGameSessionRequestModelMarshaller INSTANCE = new CreateGameSessionRequestModelMarshaller();

    private CreateGameSessionRequestModelMarshaller() {
    }

    public static CreateGameSessionRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateGameSessionRequest createGameSessionRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createGameSessionRequest), (String)"createGameSessionRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createGameSessionRequest.fleetId(), FLEETID_BINDING);
            protocolMarshaller.marshall((Object)createGameSessionRequest.aliasId(), ALIASID_BINDING);
            protocolMarshaller.marshall((Object)createGameSessionRequest.maximumPlayerSessionCount(), MAXIMUMPLAYERSESSIONCOUNT_BINDING);
            protocolMarshaller.marshall((Object)createGameSessionRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall(createGameSessionRequest.gameProperties(), GAMEPROPERTIES_BINDING);
            protocolMarshaller.marshall((Object)createGameSessionRequest.creatorId(), CREATORID_BINDING);
            protocolMarshaller.marshall((Object)createGameSessionRequest.gameSessionId(), GAMESESSIONID_BINDING);
            protocolMarshaller.marshall((Object)createGameSessionRequest.idempotencyToken(), IDEMPOTENCYTOKEN_BINDING);
            protocolMarshaller.marshall((Object)createGameSessionRequest.gameSessionData(), GAMESESSIONDATA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

