/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.services.gamelift.model.Player;
import software.amazon.awssdk.services.gamelift.model.PlayerListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StartMatchmakingRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, StartMatchmakingRequest> {
    private final String ticketId;
    private final String configurationName;
    private final List<Player> players;

    private StartMatchmakingRequest(BuilderImpl builder) {
        super(builder);
        this.ticketId = builder.ticketId;
        this.configurationName = builder.configurationName;
        this.players = builder.players;
    }

    public String ticketId() {
        return this.ticketId;
    }

    public String configurationName() {
        return this.configurationName;
    }

    public List<Player> players() {
        return this.players;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ticketId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.players());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMatchmakingRequest)) {
            return false;
        }
        StartMatchmakingRequest other = (StartMatchmakingRequest)((Object)obj);
        return Objects.equals(this.ticketId(), other.ticketId()) && Objects.equals(this.configurationName(), other.configurationName()) && Objects.equals(this.players(), other.players());
    }

    public String toString() {
        return ToString.builder((String)"StartMatchmakingRequest").add("TicketId", (Object)this.ticketId()).add("ConfigurationName", (Object)this.configurationName()).add("Players", this.players()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TicketId": {
                return Optional.of(clazz.cast(this.ticketId()));
            }
            case "ConfigurationName": {
                return Optional.of(clazz.cast(this.configurationName()));
            }
            case "Players": {
                return Optional.of(clazz.cast(this.players()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String ticketId;
        private String configurationName;
        private List<Player> players;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMatchmakingRequest model) {
            super(model);
            this.ticketId(model.ticketId);
            this.configurationName(model.configurationName);
            this.players(model.players);
        }

        public final String getTicketId() {
            return this.ticketId;
        }

        @Override
        public final Builder ticketId(String ticketId) {
            this.ticketId = ticketId;
            return this;
        }

        public final void setTicketId(String ticketId) {
            this.ticketId = ticketId;
        }

        public final String getConfigurationName() {
            return this.configurationName;
        }

        @Override
        public final Builder configurationName(String configurationName) {
            this.configurationName = configurationName;
            return this;
        }

        public final void setConfigurationName(String configurationName) {
            this.configurationName = configurationName;
        }

        public final Collection<Player.Builder> getPlayers() {
            return this.players != null ? (Collection)this.players.stream().map(Player::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder players(Collection<Player> players) {
            this.players = PlayerListCopier.copy(players);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder players(Player ... players) {
            this.players(Arrays.asList(players));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder players(Consumer<Player.Builder> ... players) {
            this.players(Stream.of(players).map(c -> (Player)((Player.Builder)Player.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPlayers(Collection<Player.BuilderImpl> players) {
            this.players = PlayerListCopier.copyFromBuilder(players);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public StartMatchmakingRequest build() {
            return new StartMatchmakingRequest(this);
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    CopyableBuilder<Builder, StartMatchmakingRequest> {
        public Builder ticketId(String var1);

        public Builder configurationName(String var1);

        public Builder players(Collection<Player> var1);

        public Builder players(Player ... var1);

        public Builder players(Consumer<Player.Builder> ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

