/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.services.gamelift.model.PlayerSession;
import software.amazon.awssdk.services.gamelift.model.PlayerSessionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribePlayerSessionsResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, DescribePlayerSessionsResponse> {
    private final List<PlayerSession> playerSessions;
    private final String nextToken;

    private DescribePlayerSessionsResponse(BuilderImpl builder) {
        super(builder);
        this.playerSessions = builder.playerSessions;
        this.nextToken = builder.nextToken;
    }

    public List<PlayerSession> playerSessions() {
        return this.playerSessions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.playerSessions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePlayerSessionsResponse)) {
            return false;
        }
        DescribePlayerSessionsResponse other = (DescribePlayerSessionsResponse)((Object)obj);
        return Objects.equals(this.playerSessions(), other.playerSessions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribePlayerSessionsResponse").add("PlayerSessions", this.playerSessions()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlayerSessions": {
                return Optional.of(clazz.cast(this.playerSessions()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private List<PlayerSession> playerSessions;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePlayerSessionsResponse model) {
            super(model);
            this.playerSessions(model.playerSessions);
            this.nextToken(model.nextToken);
        }

        public final Collection<PlayerSession.Builder> getPlayerSessions() {
            return this.playerSessions != null ? (Collection)this.playerSessions.stream().map(PlayerSession::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder playerSessions(Collection<PlayerSession> playerSessions) {
            this.playerSessions = PlayerSessionListCopier.copy(playerSessions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playerSessions(PlayerSession ... playerSessions) {
            this.playerSessions(Arrays.asList(playerSessions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playerSessions(Consumer<PlayerSession.Builder> ... playerSessions) {
            this.playerSessions(Stream.of(playerSessions).map(c -> (PlayerSession)((PlayerSession.Builder)PlayerSession.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPlayerSessions(Collection<PlayerSession.BuilderImpl> playerSessions) {
            this.playerSessions = PlayerSessionListCopier.copyFromBuilder(playerSessions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribePlayerSessionsResponse build() {
            return new DescribePlayerSessionsResponse(this);
        }
    }

    public static interface Builder
    extends GameLiftResponse.Builder,
    CopyableBuilder<Builder, DescribePlayerSessionsResponse> {
        public Builder playerSessions(Collection<PlayerSession> var1);

        public Builder playerSessions(PlayerSession ... var1);

        public Builder playerSessions(Consumer<PlayerSession.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

