/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateVpcPeeringConnectionRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, CreateVpcPeeringConnectionRequest> {
    private final String fleetId;
    private final String peerVpcAwsAccountId;
    private final String peerVpcId;

    private CreateVpcPeeringConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.peerVpcAwsAccountId = builder.peerVpcAwsAccountId;
        this.peerVpcId = builder.peerVpcId;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public String peerVpcAwsAccountId() {
        return this.peerVpcAwsAccountId;
    }

    public String peerVpcId() {
        return this.peerVpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerVpcAwsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerVpcId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcPeeringConnectionRequest)) {
            return false;
        }
        CreateVpcPeeringConnectionRequest other = (CreateVpcPeeringConnectionRequest)((Object)obj);
        return Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.peerVpcAwsAccountId(), other.peerVpcAwsAccountId()) && Objects.equals(this.peerVpcId(), other.peerVpcId());
    }

    public String toString() {
        return ToString.builder((String)"CreateVpcPeeringConnectionRequest").add("FleetId", (Object)this.fleetId()).add("PeerVpcAwsAccountId", (Object)this.peerVpcAwsAccountId()).add("PeerVpcId", (Object)this.peerVpcId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.of(clazz.cast(this.fleetId()));
            }
            case "PeerVpcAwsAccountId": {
                return Optional.of(clazz.cast(this.peerVpcAwsAccountId()));
            }
            case "PeerVpcId": {
                return Optional.of(clazz.cast(this.peerVpcId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String fleetId;
        private String peerVpcAwsAccountId;
        private String peerVpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcPeeringConnectionRequest model) {
            super(model);
            this.fleetId(model.fleetId);
            this.peerVpcAwsAccountId(model.peerVpcAwsAccountId);
            this.peerVpcId(model.peerVpcId);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final String getPeerVpcAwsAccountId() {
            return this.peerVpcAwsAccountId;
        }

        @Override
        public final Builder peerVpcAwsAccountId(String peerVpcAwsAccountId) {
            this.peerVpcAwsAccountId = peerVpcAwsAccountId;
            return this;
        }

        public final void setPeerVpcAwsAccountId(String peerVpcAwsAccountId) {
            this.peerVpcAwsAccountId = peerVpcAwsAccountId;
        }

        public final String getPeerVpcId() {
            return this.peerVpcId;
        }

        @Override
        public final Builder peerVpcId(String peerVpcId) {
            this.peerVpcId = peerVpcId;
            return this;
        }

        public final void setPeerVpcId(String peerVpcId) {
            this.peerVpcId = peerVpcId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateVpcPeeringConnectionRequest build() {
            return new CreateVpcPeeringConnectionRequest(this);
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    CopyableBuilder<Builder, CreateVpcPeeringConnectionRequest> {
        public Builder fleetId(String var1);

        public Builder peerVpcAwsAccountId(String var1);

        public Builder peerVpcId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

