/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.model.FleetCapacity;

@SdkInternalApi
public class FleetCapacityMarshaller {
    private static final MarshallingInfo<String> FLEETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FleetId").build();
    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceType").build();
    private static final MarshallingInfo<StructuredPojo> INSTANCECOUNTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceCounts").build();
    private static final FleetCapacityMarshaller instance = new FleetCapacityMarshaller();

    public static FleetCapacityMarshaller getInstance() {
        return instance;
    }

    public void marshall(FleetCapacity fleetCapacity, ProtocolMarshaller protocolMarshaller) {
        if (fleetCapacity == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)fleetCapacity.fleetId(), FLEETID_BINDING);
            protocolMarshaller.marshall((Object)fleetCapacity.instanceType(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)fleetCapacity.instanceCounts(), INSTANCECOUNTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

