/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.gamelift.model.PlayerSessionCreationPolicy;
import software.amazon.awssdk.services.gamelift.model.ProtectionPolicy;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateGameSessionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateGameSessionRequest> {
    private final String gameSessionId;
    private final Integer maximumPlayerSessionCount;
    private final String name;
    private final String playerSessionCreationPolicy;
    private final String protectionPolicy;

    private UpdateGameSessionRequest(BuilderImpl builder) {
        this.gameSessionId = builder.gameSessionId;
        this.maximumPlayerSessionCount = builder.maximumPlayerSessionCount;
        this.name = builder.name;
        this.playerSessionCreationPolicy = builder.playerSessionCreationPolicy;
        this.protectionPolicy = builder.protectionPolicy;
    }

    public String gameSessionId() {
        return this.gameSessionId;
    }

    public Integer maximumPlayerSessionCount() {
        return this.maximumPlayerSessionCount;
    }

    public String name() {
        return this.name;
    }

    public String playerSessionCreationPolicy() {
        return this.playerSessionCreationPolicy;
    }

    public String protectionPolicy() {
        return this.protectionPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.gameSessionId() == null ? 0 : this.gameSessionId().hashCode());
        hashCode = 31 * hashCode + (this.maximumPlayerSessionCount() == null ? 0 : this.maximumPlayerSessionCount().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.playerSessionCreationPolicy() == null ? 0 : this.playerSessionCreationPolicy().hashCode());
        hashCode = 31 * hashCode + (this.protectionPolicy() == null ? 0 : this.protectionPolicy().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGameSessionRequest)) {
            return false;
        }
        UpdateGameSessionRequest other = (UpdateGameSessionRequest)((Object)obj);
        if (other.gameSessionId() == null ^ this.gameSessionId() == null) {
            return false;
        }
        if (other.gameSessionId() != null && !other.gameSessionId().equals(this.gameSessionId())) {
            return false;
        }
        if (other.maximumPlayerSessionCount() == null ^ this.maximumPlayerSessionCount() == null) {
            return false;
        }
        if (other.maximumPlayerSessionCount() != null && !other.maximumPlayerSessionCount().equals(this.maximumPlayerSessionCount())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.playerSessionCreationPolicy() == null ^ this.playerSessionCreationPolicy() == null) {
            return false;
        }
        if (other.playerSessionCreationPolicy() != null && !other.playerSessionCreationPolicy().equals(this.playerSessionCreationPolicy())) {
            return false;
        }
        if (other.protectionPolicy() == null ^ this.protectionPolicy() == null) {
            return false;
        }
        return other.protectionPolicy() == null || other.protectionPolicy().equals(this.protectionPolicy());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.gameSessionId() != null) {
            sb.append("GameSessionId: ").append(this.gameSessionId()).append(",");
        }
        if (this.maximumPlayerSessionCount() != null) {
            sb.append("MaximumPlayerSessionCount: ").append(this.maximumPlayerSessionCount()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.playerSessionCreationPolicy() != null) {
            sb.append("PlayerSessionCreationPolicy: ").append(this.playerSessionCreationPolicy()).append(",");
        }
        if (this.protectionPolicy() != null) {
            sb.append("ProtectionPolicy: ").append(this.protectionPolicy()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String gameSessionId;
        private Integer maximumPlayerSessionCount;
        private String name;
        private String playerSessionCreationPolicy;
        private String protectionPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGameSessionRequest model) {
            this.setGameSessionId(model.gameSessionId);
            this.setMaximumPlayerSessionCount(model.maximumPlayerSessionCount);
            this.setName(model.name);
            this.setPlayerSessionCreationPolicy(model.playerSessionCreationPolicy);
            this.setProtectionPolicy(model.protectionPolicy);
        }

        public final String getGameSessionId() {
            return this.gameSessionId;
        }

        @Override
        public final Builder gameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
            return this;
        }

        public final void setGameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
        }

        public final Integer getMaximumPlayerSessionCount() {
            return this.maximumPlayerSessionCount;
        }

        @Override
        public final Builder maximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
            return this;
        }

        public final void setMaximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getPlayerSessionCreationPolicy() {
            return this.playerSessionCreationPolicy;
        }

        @Override
        public final Builder playerSessionCreationPolicy(String playerSessionCreationPolicy) {
            this.playerSessionCreationPolicy = playerSessionCreationPolicy;
            return this;
        }

        @Override
        public final Builder playerSessionCreationPolicy(PlayerSessionCreationPolicy playerSessionCreationPolicy) {
            this.playerSessionCreationPolicy(playerSessionCreationPolicy.toString());
            return this;
        }

        public final void setPlayerSessionCreationPolicy(String playerSessionCreationPolicy) {
            this.playerSessionCreationPolicy = playerSessionCreationPolicy;
        }

        public final void setPlayerSessionCreationPolicy(PlayerSessionCreationPolicy playerSessionCreationPolicy) {
            this.playerSessionCreationPolicy(playerSessionCreationPolicy.toString());
        }

        public final String getProtectionPolicy() {
            return this.protectionPolicy;
        }

        @Override
        public final Builder protectionPolicy(String protectionPolicy) {
            this.protectionPolicy = protectionPolicy;
            return this;
        }

        @Override
        public final Builder protectionPolicy(ProtectionPolicy protectionPolicy) {
            this.protectionPolicy(protectionPolicy.toString());
            return this;
        }

        public final void setProtectionPolicy(String protectionPolicy) {
            this.protectionPolicy = protectionPolicy;
        }

        public final void setProtectionPolicy(ProtectionPolicy protectionPolicy) {
            this.protectionPolicy(protectionPolicy.toString());
        }

        public UpdateGameSessionRequest build() {
            return new UpdateGameSessionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateGameSessionRequest> {
        public Builder gameSessionId(String var1);

        public Builder maximumPlayerSessionCount(Integer var1);

        public Builder name(String var1);

        public Builder playerSessionCreationPolicy(String var1);

        public Builder playerSessionCreationPolicy(PlayerSessionCreationPolicy var1);

        public Builder protectionPolicy(String var1);

        public Builder protectionPolicy(ProtectionPolicy var1);
    }
}

