/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.gamelift.model.GameSession;
import software.amazon.awssdk.services.gamelift.model.GameSessionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SearchGameSessionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, SearchGameSessionsResponse> {
    private final List<GameSession> gameSessions;
    private final String nextToken;

    private SearchGameSessionsResponse(BuilderImpl builder) {
        this.gameSessions = builder.gameSessions;
        this.nextToken = builder.nextToken;
    }

    public List<GameSession> gameSessions() {
        return this.gameSessions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.gameSessions() == null ? 0 : this.gameSessions().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchGameSessionsResponse)) {
            return false;
        }
        SearchGameSessionsResponse other = (SearchGameSessionsResponse)((Object)obj);
        if (other.gameSessions() == null ^ this.gameSessions() == null) {
            return false;
        }
        if (other.gameSessions() != null && !other.gameSessions().equals(this.gameSessions())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.gameSessions() != null) {
            sb.append("GameSessions: ").append(this.gameSessions()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<GameSession> gameSessions;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchGameSessionsResponse model) {
            this.setGameSessions(model.gameSessions);
            this.setNextToken(model.nextToken);
        }

        public final Collection<GameSession> getGameSessions() {
            return this.gameSessions;
        }

        @Override
        public final Builder gameSessions(Collection<GameSession> gameSessions) {
            this.gameSessions = GameSessionListCopier.copy(gameSessions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameSessions(GameSession ... gameSessions) {
            if (this.gameSessions == null) {
                this.gameSessions = new ArrayList<GameSession>(gameSessions.length);
            }
            for (GameSession e : gameSessions) {
                this.gameSessions.add(e);
            }
            return this;
        }

        public final void setGameSessions(Collection<GameSession> gameSessions) {
            this.gameSessions = GameSessionListCopier.copy(gameSessions);
        }

        @SafeVarargs
        public final void setGameSessions(GameSession ... gameSessions) {
            if (this.gameSessions == null) {
                this.gameSessions = new ArrayList<GameSession>(gameSessions.length);
            }
            for (GameSession e : gameSessions) {
                this.gameSessions.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public SearchGameSessionsResponse build() {
            return new SearchGameSessionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SearchGameSessionsResponse> {
        public Builder gameSessions(Collection<GameSession> var1);

        public Builder gameSessions(GameSession ... var1);

        public Builder nextToken(String var1);
    }
}

