/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.stream.Stream;
import software.amazon.awssdk.util.StringUtils;

public enum MetricName {
    ActivatingGameSessions("ActivatingGameSessions"),
    ActiveGameSessions("ActiveGameSessions"),
    ActiveInstances("ActiveInstances"),
    AvailableGameSessions("AvailableGameSessions"),
    AvailablePlayerSessions("AvailablePlayerSessions"),
    CurrentPlayerSessions("CurrentPlayerSessions"),
    IdleInstances("IdleInstances"),
    PercentAvailableGameSessions("PercentAvailableGameSessions"),
    PercentIdleInstances("PercentIdleInstances"),
    QueueDepth("QueueDepth"),
    WaitTime("WaitTime");

    private final String value;

    private MetricName(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static MetricName fromValue(String value) {
        if (StringUtils.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        return Stream.of(MetricName.values()).filter(e -> e.toString().equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot create enum from " + value + " value!"));
    }
}

