/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.model.GameSession;
import software.amazon.awssdk.services.gamelift.model.ProtectionPolicy;
import software.amazon.awssdk.services.gamelift.transform.GameSessionDetailMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GameSessionDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, GameSessionDetail> {
    private final GameSession gameSession;
    private final String protectionPolicy;

    private GameSessionDetail(BuilderImpl builder) {
        this.gameSession = builder.gameSession;
        this.protectionPolicy = builder.protectionPolicy;
    }

    public GameSession gameSession() {
        return this.gameSession;
    }

    public String protectionPolicy() {
        return this.protectionPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.gameSession() == null ? 0 : this.gameSession().hashCode());
        hashCode = 31 * hashCode + (this.protectionPolicy() == null ? 0 : this.protectionPolicy().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GameSessionDetail)) {
            return false;
        }
        GameSessionDetail other = (GameSessionDetail)obj;
        if (other.gameSession() == null ^ this.gameSession() == null) {
            return false;
        }
        if (other.gameSession() != null && !other.gameSession().equals(this.gameSession())) {
            return false;
        }
        if (other.protectionPolicy() == null ^ this.protectionPolicy() == null) {
            return false;
        }
        return other.protectionPolicy() == null || other.protectionPolicy().equals(this.protectionPolicy());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.gameSession() != null) {
            sb.append("GameSession: ").append(this.gameSession()).append(",");
        }
        if (this.protectionPolicy() != null) {
            sb.append("ProtectionPolicy: ").append(this.protectionPolicy()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GameSessionDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private GameSession gameSession;
        private String protectionPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(GameSessionDetail model) {
            this.setGameSession(model.gameSession);
            this.setProtectionPolicy(model.protectionPolicy);
        }

        public final GameSession getGameSession() {
            return this.gameSession;
        }

        @Override
        public final Builder gameSession(GameSession gameSession) {
            this.gameSession = gameSession;
            return this;
        }

        public final void setGameSession(GameSession gameSession) {
            this.gameSession = gameSession;
        }

        public final String getProtectionPolicy() {
            return this.protectionPolicy;
        }

        @Override
        public final Builder protectionPolicy(String protectionPolicy) {
            this.protectionPolicy = protectionPolicy;
            return this;
        }

        @Override
        public final Builder protectionPolicy(ProtectionPolicy protectionPolicy) {
            this.protectionPolicy(protectionPolicy.toString());
            return this;
        }

        public final void setProtectionPolicy(String protectionPolicy) {
            this.protectionPolicy = protectionPolicy;
        }

        public final void setProtectionPolicy(ProtectionPolicy protectionPolicy) {
            this.protectionPolicy(protectionPolicy.toString());
        }

        public GameSessionDetail build() {
            return new GameSessionDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GameSessionDetail> {
        public Builder gameSession(GameSession var1);

        public Builder protectionPolicy(String var1);

        public Builder protectionPolicy(ProtectionPolicy var1);
    }
}

