/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.gamelift.model.GameProperty;
import software.amazon.awssdk.services.gamelift.model.GamePropertyListCopier;
import software.amazon.awssdk.services.gamelift.model.GameSessionStatus;
import software.amazon.awssdk.services.gamelift.model.PlayerSessionCreationPolicy;
import software.amazon.awssdk.services.gamelift.transform.GameSessionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GameSession
implements StructuredPojo,
ToCopyableBuilder<Builder, GameSession> {
    private final String gameSessionId;
    private final String name;
    private final String fleetId;
    private final Date creationTime;
    private final Date terminationTime;
    private final Integer currentPlayerSessionCount;
    private final Integer maximumPlayerSessionCount;
    private final String status;
    private final List<GameProperty> gameProperties;
    private final String ipAddress;
    private final Integer port;
    private final String playerSessionCreationPolicy;
    private final String creatorId;

    private GameSession(BuilderImpl builder) {
        this.gameSessionId = builder.gameSessionId;
        this.name = builder.name;
        this.fleetId = builder.fleetId;
        this.creationTime = builder.creationTime;
        this.terminationTime = builder.terminationTime;
        this.currentPlayerSessionCount = builder.currentPlayerSessionCount;
        this.maximumPlayerSessionCount = builder.maximumPlayerSessionCount;
        this.status = builder.status;
        this.gameProperties = builder.gameProperties;
        this.ipAddress = builder.ipAddress;
        this.port = builder.port;
        this.playerSessionCreationPolicy = builder.playerSessionCreationPolicy;
        this.creatorId = builder.creatorId;
    }

    public String gameSessionId() {
        return this.gameSessionId;
    }

    public String name() {
        return this.name;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public Date creationTime() {
        return this.creationTime;
    }

    public Date terminationTime() {
        return this.terminationTime;
    }

    public Integer currentPlayerSessionCount() {
        return this.currentPlayerSessionCount;
    }

    public Integer maximumPlayerSessionCount() {
        return this.maximumPlayerSessionCount;
    }

    public String status() {
        return this.status;
    }

    public List<GameProperty> gameProperties() {
        return this.gameProperties;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public Integer port() {
        return this.port;
    }

    public String playerSessionCreationPolicy() {
        return this.playerSessionCreationPolicy;
    }

    public String creatorId() {
        return this.creatorId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.gameSessionId() == null ? 0 : this.gameSessionId().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.fleetId() == null ? 0 : this.fleetId().hashCode());
        hashCode = 31 * hashCode + (this.creationTime() == null ? 0 : this.creationTime().hashCode());
        hashCode = 31 * hashCode + (this.terminationTime() == null ? 0 : this.terminationTime().hashCode());
        hashCode = 31 * hashCode + (this.currentPlayerSessionCount() == null ? 0 : this.currentPlayerSessionCount().hashCode());
        hashCode = 31 * hashCode + (this.maximumPlayerSessionCount() == null ? 0 : this.maximumPlayerSessionCount().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.gameProperties() == null ? 0 : this.gameProperties().hashCode());
        hashCode = 31 * hashCode + (this.ipAddress() == null ? 0 : this.ipAddress().hashCode());
        hashCode = 31 * hashCode + (this.port() == null ? 0 : this.port().hashCode());
        hashCode = 31 * hashCode + (this.playerSessionCreationPolicy() == null ? 0 : this.playerSessionCreationPolicy().hashCode());
        hashCode = 31 * hashCode + (this.creatorId() == null ? 0 : this.creatorId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GameSession)) {
            return false;
        }
        GameSession other = (GameSession)obj;
        if (other.gameSessionId() == null ^ this.gameSessionId() == null) {
            return false;
        }
        if (other.gameSessionId() != null && !other.gameSessionId().equals(this.gameSessionId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.fleetId() == null ^ this.fleetId() == null) {
            return false;
        }
        if (other.fleetId() != null && !other.fleetId().equals(this.fleetId())) {
            return false;
        }
        if (other.creationTime() == null ^ this.creationTime() == null) {
            return false;
        }
        if (other.creationTime() != null && !other.creationTime().equals(this.creationTime())) {
            return false;
        }
        if (other.terminationTime() == null ^ this.terminationTime() == null) {
            return false;
        }
        if (other.terminationTime() != null && !other.terminationTime().equals(this.terminationTime())) {
            return false;
        }
        if (other.currentPlayerSessionCount() == null ^ this.currentPlayerSessionCount() == null) {
            return false;
        }
        if (other.currentPlayerSessionCount() != null && !other.currentPlayerSessionCount().equals(this.currentPlayerSessionCount())) {
            return false;
        }
        if (other.maximumPlayerSessionCount() == null ^ this.maximumPlayerSessionCount() == null) {
            return false;
        }
        if (other.maximumPlayerSessionCount() != null && !other.maximumPlayerSessionCount().equals(this.maximumPlayerSessionCount())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.gameProperties() == null ^ this.gameProperties() == null) {
            return false;
        }
        if (other.gameProperties() != null && !other.gameProperties().equals(this.gameProperties())) {
            return false;
        }
        if (other.ipAddress() == null ^ this.ipAddress() == null) {
            return false;
        }
        if (other.ipAddress() != null && !other.ipAddress().equals(this.ipAddress())) {
            return false;
        }
        if (other.port() == null ^ this.port() == null) {
            return false;
        }
        if (other.port() != null && !other.port().equals(this.port())) {
            return false;
        }
        if (other.playerSessionCreationPolicy() == null ^ this.playerSessionCreationPolicy() == null) {
            return false;
        }
        if (other.playerSessionCreationPolicy() != null && !other.playerSessionCreationPolicy().equals(this.playerSessionCreationPolicy())) {
            return false;
        }
        if (other.creatorId() == null ^ this.creatorId() == null) {
            return false;
        }
        return other.creatorId() == null || other.creatorId().equals(this.creatorId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.gameSessionId() != null) {
            sb.append("GameSessionId: ").append(this.gameSessionId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.fleetId() != null) {
            sb.append("FleetId: ").append(this.fleetId()).append(",");
        }
        if (this.creationTime() != null) {
            sb.append("CreationTime: ").append(this.creationTime()).append(",");
        }
        if (this.terminationTime() != null) {
            sb.append("TerminationTime: ").append(this.terminationTime()).append(",");
        }
        if (this.currentPlayerSessionCount() != null) {
            sb.append("CurrentPlayerSessionCount: ").append(this.currentPlayerSessionCount()).append(",");
        }
        if (this.maximumPlayerSessionCount() != null) {
            sb.append("MaximumPlayerSessionCount: ").append(this.maximumPlayerSessionCount()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.gameProperties() != null) {
            sb.append("GameProperties: ").append(this.gameProperties()).append(",");
        }
        if (this.ipAddress() != null) {
            sb.append("IpAddress: ").append(this.ipAddress()).append(",");
        }
        if (this.port() != null) {
            sb.append("Port: ").append(this.port()).append(",");
        }
        if (this.playerSessionCreationPolicy() != null) {
            sb.append("PlayerSessionCreationPolicy: ").append(this.playerSessionCreationPolicy()).append(",");
        }
        if (this.creatorId() != null) {
            sb.append("CreatorId: ").append(this.creatorId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GameSessionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String gameSessionId;
        private String name;
        private String fleetId;
        private Date creationTime;
        private Date terminationTime;
        private Integer currentPlayerSessionCount;
        private Integer maximumPlayerSessionCount;
        private String status;
        private List<GameProperty> gameProperties;
        private String ipAddress;
        private Integer port;
        private String playerSessionCreationPolicy;
        private String creatorId;

        private BuilderImpl() {
        }

        private BuilderImpl(GameSession model) {
            this.setGameSessionId(model.gameSessionId);
            this.setName(model.name);
            this.setFleetId(model.fleetId);
            this.setCreationTime(model.creationTime);
            this.setTerminationTime(model.terminationTime);
            this.setCurrentPlayerSessionCount(model.currentPlayerSessionCount);
            this.setMaximumPlayerSessionCount(model.maximumPlayerSessionCount);
            this.setStatus(model.status);
            this.setGameProperties(model.gameProperties);
            this.setIpAddress(model.ipAddress);
            this.setPort(model.port);
            this.setPlayerSessionCreationPolicy(model.playerSessionCreationPolicy);
            this.setCreatorId(model.creatorId);
        }

        public final String getGameSessionId() {
            return this.gameSessionId;
        }

        @Override
        public final Builder gameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
            return this;
        }

        public final void setGameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final Date getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Date creationTime) {
            this.creationTime = StandardMemberCopier.copy((Date)creationTime);
            return this;
        }

        public final void setCreationTime(Date creationTime) {
            this.creationTime = StandardMemberCopier.copy((Date)creationTime);
        }

        public final Date getTerminationTime() {
            return this.terminationTime;
        }

        @Override
        public final Builder terminationTime(Date terminationTime) {
            this.terminationTime = StandardMemberCopier.copy((Date)terminationTime);
            return this;
        }

        public final void setTerminationTime(Date terminationTime) {
            this.terminationTime = StandardMemberCopier.copy((Date)terminationTime);
        }

        public final Integer getCurrentPlayerSessionCount() {
            return this.currentPlayerSessionCount;
        }

        @Override
        public final Builder currentPlayerSessionCount(Integer currentPlayerSessionCount) {
            this.currentPlayerSessionCount = currentPlayerSessionCount;
            return this;
        }

        public final void setCurrentPlayerSessionCount(Integer currentPlayerSessionCount) {
            this.currentPlayerSessionCount = currentPlayerSessionCount;
        }

        public final Integer getMaximumPlayerSessionCount() {
            return this.maximumPlayerSessionCount;
        }

        @Override
        public final Builder maximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
            return this;
        }

        public final void setMaximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GameSessionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(GameSessionStatus status) {
            this.status(status.toString());
        }

        public final Collection<GameProperty> getGameProperties() {
            return this.gameProperties;
        }

        @Override
        public final Builder gameProperties(Collection<GameProperty> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copy(gameProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameProperties(GameProperty ... gameProperties) {
            if (this.gameProperties == null) {
                this.gameProperties = new ArrayList<GameProperty>(gameProperties.length);
            }
            for (GameProperty e : gameProperties) {
                this.gameProperties.add(e);
            }
            return this;
        }

        public final void setGameProperties(Collection<GameProperty> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copy(gameProperties);
        }

        @SafeVarargs
        public final void setGameProperties(GameProperty ... gameProperties) {
            if (this.gameProperties == null) {
                this.gameProperties = new ArrayList<GameProperty>(gameProperties.length);
            }
            for (GameProperty e : gameProperties) {
                this.gameProperties.add(e);
            }
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getPlayerSessionCreationPolicy() {
            return this.playerSessionCreationPolicy;
        }

        @Override
        public final Builder playerSessionCreationPolicy(String playerSessionCreationPolicy) {
            this.playerSessionCreationPolicy = playerSessionCreationPolicy;
            return this;
        }

        @Override
        public final Builder playerSessionCreationPolicy(PlayerSessionCreationPolicy playerSessionCreationPolicy) {
            this.playerSessionCreationPolicy(playerSessionCreationPolicy.toString());
            return this;
        }

        public final void setPlayerSessionCreationPolicy(String playerSessionCreationPolicy) {
            this.playerSessionCreationPolicy = playerSessionCreationPolicy;
        }

        public final void setPlayerSessionCreationPolicy(PlayerSessionCreationPolicy playerSessionCreationPolicy) {
            this.playerSessionCreationPolicy(playerSessionCreationPolicy.toString());
        }

        public final String getCreatorId() {
            return this.creatorId;
        }

        @Override
        public final Builder creatorId(String creatorId) {
            this.creatorId = creatorId;
            return this;
        }

        public final void setCreatorId(String creatorId) {
            this.creatorId = creatorId;
        }

        public GameSession build() {
            return new GameSession(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GameSession> {
        public Builder gameSessionId(String var1);

        public Builder name(String var1);

        public Builder fleetId(String var1);

        public Builder creationTime(Date var1);

        public Builder terminationTime(Date var1);

        public Builder currentPlayerSessionCount(Integer var1);

        public Builder maximumPlayerSessionCount(Integer var1);

        public Builder status(String var1);

        public Builder status(GameSessionStatus var1);

        public Builder gameProperties(Collection<GameProperty> var1);

        public Builder gameProperties(GameProperty ... var1);

        public Builder ipAddress(String var1);

        public Builder port(Integer var1);

        public Builder playerSessionCreationPolicy(String var1);

        public Builder playerSessionCreationPolicy(PlayerSessionCreationPolicy var1);

        public Builder creatorId(String var1);
    }
}

