/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.model.EC2InstanceCounts;
import software.amazon.awssdk.services.gamelift.model.EC2InstanceType;
import software.amazon.awssdk.services.gamelift.transform.FleetCapacityMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FleetCapacity
implements StructuredPojo,
ToCopyableBuilder<Builder, FleetCapacity> {
    private final String fleetId;
    private final String instanceType;
    private final EC2InstanceCounts instanceCounts;

    private FleetCapacity(BuilderImpl builder) {
        this.fleetId = builder.fleetId;
        this.instanceType = builder.instanceType;
        this.instanceCounts = builder.instanceCounts;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public EC2InstanceCounts instanceCounts() {
        return this.instanceCounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.fleetId() == null ? 0 : this.fleetId().hashCode());
        hashCode = 31 * hashCode + (this.instanceType() == null ? 0 : this.instanceType().hashCode());
        hashCode = 31 * hashCode + (this.instanceCounts() == null ? 0 : this.instanceCounts().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetCapacity)) {
            return false;
        }
        FleetCapacity other = (FleetCapacity)obj;
        if (other.fleetId() == null ^ this.fleetId() == null) {
            return false;
        }
        if (other.fleetId() != null && !other.fleetId().equals(this.fleetId())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.instanceCounts() == null ^ this.instanceCounts() == null) {
            return false;
        }
        return other.instanceCounts() == null || other.instanceCounts().equals(this.instanceCounts());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fleetId() != null) {
            sb.append("FleetId: ").append(this.fleetId()).append(",");
        }
        if (this.instanceType() != null) {
            sb.append("InstanceType: ").append(this.instanceType()).append(",");
        }
        if (this.instanceCounts() != null) {
            sb.append("InstanceCounts: ").append(this.instanceCounts()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FleetCapacityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String fleetId;
        private String instanceType;
        private EC2InstanceCounts instanceCounts;

        private BuilderImpl() {
        }

        private BuilderImpl(FleetCapacity model) {
            this.setFleetId(model.fleetId);
            this.setInstanceType(model.instanceType);
            this.setInstanceCounts(model.instanceCounts);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(EC2InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final void setInstanceType(EC2InstanceType instanceType) {
            this.instanceType(instanceType.toString());
        }

        public final EC2InstanceCounts getInstanceCounts() {
            return this.instanceCounts;
        }

        @Override
        public final Builder instanceCounts(EC2InstanceCounts instanceCounts) {
            this.instanceCounts = instanceCounts;
            return this;
        }

        public final void setInstanceCounts(EC2InstanceCounts instanceCounts) {
            this.instanceCounts = instanceCounts;
        }

        public FleetCapacity build() {
            return new FleetCapacity(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FleetCapacity> {
        public Builder fleetId(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(EC2InstanceType var1);

        public Builder instanceCounts(EC2InstanceCounts var1);
    }
}

