/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.transform.DesiredPlayerSessionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DesiredPlayerSession
implements StructuredPojo,
ToCopyableBuilder<Builder, DesiredPlayerSession> {
    private final String playerId;
    private final String playerData;

    private DesiredPlayerSession(BuilderImpl builder) {
        this.playerId = builder.playerId;
        this.playerData = builder.playerData;
    }

    public String playerId() {
        return this.playerId;
    }

    public String playerData() {
        return this.playerData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.playerId() == null ? 0 : this.playerId().hashCode());
        hashCode = 31 * hashCode + (this.playerData() == null ? 0 : this.playerData().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DesiredPlayerSession)) {
            return false;
        }
        DesiredPlayerSession other = (DesiredPlayerSession)obj;
        if (other.playerId() == null ^ this.playerId() == null) {
            return false;
        }
        if (other.playerId() != null && !other.playerId().equals(this.playerId())) {
            return false;
        }
        if (other.playerData() == null ^ this.playerData() == null) {
            return false;
        }
        return other.playerData() == null || other.playerData().equals(this.playerData());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.playerId() != null) {
            sb.append("PlayerId: ").append(this.playerId()).append(",");
        }
        if (this.playerData() != null) {
            sb.append("PlayerData: ").append(this.playerData()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DesiredPlayerSessionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String playerId;
        private String playerData;

        private BuilderImpl() {
        }

        private BuilderImpl(DesiredPlayerSession model) {
            this.setPlayerId(model.playerId);
            this.setPlayerData(model.playerData);
        }

        public final String getPlayerId() {
            return this.playerId;
        }

        @Override
        public final Builder playerId(String playerId) {
            this.playerId = playerId;
            return this;
        }

        public final void setPlayerId(String playerId) {
            this.playerId = playerId;
        }

        public final String getPlayerData() {
            return this.playerData;
        }

        @Override
        public final Builder playerData(String playerData) {
            this.playerData = playerData;
            return this;
        }

        public final void setPlayerData(String playerData) {
            this.playerData = playerData;
        }

        public DesiredPlayerSession build() {
            return new DesiredPlayerSession(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DesiredPlayerSession> {
        public Builder playerId(String var1);

        public Builder playerData(String var1);
    }
}

