/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the FSx for ONTAP attachment configuration of an S3 access point attachment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3AccessPointOntapConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<S3AccessPointOntapConfiguration.Builder, S3AccessPointOntapConfiguration> {
    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeId").getter(getter(S3AccessPointOntapConfiguration::volumeId)).setter(setter(Builder::volumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").build()).build();

    private static final SdkField<OntapFileSystemIdentity> FILE_SYSTEM_IDENTITY_FIELD = SdkField
            .<OntapFileSystemIdentity> builder(MarshallingType.SDK_POJO).memberName("FileSystemIdentity")
            .getter(getter(S3AccessPointOntapConfiguration::fileSystemIdentity)).setter(setter(Builder::fileSystemIdentity))
            .constructor(OntapFileSystemIdentity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemIdentity").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_ID_FIELD,
            FILE_SYSTEM_IDENTITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String volumeId;

    private final OntapFileSystemIdentity fileSystemIdentity;

    private S3AccessPointOntapConfiguration(BuilderImpl builder) {
        this.volumeId = builder.volumeId;
        this.fileSystemIdentity = builder.fileSystemIdentity;
    }

    /**
     * <p>
     * The ID of the FSx for ONTAP volume that the S3 access point is attached to.
     * </p>
     * 
     * @return The ID of the FSx for ONTAP volume that the S3 access point is attached to.
     */
    public final String volumeId() {
        return volumeId;
    }

    /**
     * <p>
     * The file system identity used to authorize file access requests made using the S3 access point.
     * </p>
     * 
     * @return The file system identity used to authorize file access requests made using the S3 access point.
     */
    public final OntapFileSystemIdentity fileSystemIdentity() {
        return fileSystemIdentity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemIdentity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3AccessPointOntapConfiguration)) {
            return false;
        }
        S3AccessPointOntapConfiguration other = (S3AccessPointOntapConfiguration) obj;
        return Objects.equals(volumeId(), other.volumeId()) && Objects.equals(fileSystemIdentity(), other.fileSystemIdentity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3AccessPointOntapConfiguration").add("VolumeId", volumeId())
                .add("FileSystemIdentity", fileSystemIdentity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumeId":
            return Optional.ofNullable(clazz.cast(volumeId()));
        case "FileSystemIdentity":
            return Optional.ofNullable(clazz.cast(fileSystemIdentity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VolumeId", VOLUME_ID_FIELD);
        map.put("FileSystemIdentity", FILE_SYSTEM_IDENTITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3AccessPointOntapConfiguration, T> g) {
        return obj -> g.apply((S3AccessPointOntapConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3AccessPointOntapConfiguration> {
        /**
         * <p>
         * The ID of the FSx for ONTAP volume that the S3 access point is attached to.
         * </p>
         * 
         * @param volumeId
         *        The ID of the FSx for ONTAP volume that the S3 access point is attached to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        /**
         * <p>
         * The file system identity used to authorize file access requests made using the S3 access point.
         * </p>
         * 
         * @param fileSystemIdentity
         *        The file system identity used to authorize file access requests made using the S3 access point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemIdentity(OntapFileSystemIdentity fileSystemIdentity);

        /**
         * <p>
         * The file system identity used to authorize file access requests made using the S3 access point.
         * </p>
         * This is a convenience method that creates an instance of the {@link OntapFileSystemIdentity.Builder} avoiding
         * the need to create one manually via {@link OntapFileSystemIdentity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OntapFileSystemIdentity.Builder#build()} is called immediately
         * and its result is passed to {@link #fileSystemIdentity(OntapFileSystemIdentity)}.
         * 
         * @param fileSystemIdentity
         *        a consumer that will call methods on {@link OntapFileSystemIdentity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileSystemIdentity(OntapFileSystemIdentity)
         */
        default Builder fileSystemIdentity(Consumer<OntapFileSystemIdentity.Builder> fileSystemIdentity) {
            return fileSystemIdentity(OntapFileSystemIdentity.builder().applyMutation(fileSystemIdentity).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String volumeId;

        private OntapFileSystemIdentity fileSystemIdentity;

        private BuilderImpl() {
        }

        private BuilderImpl(S3AccessPointOntapConfiguration model) {
            volumeId(model.volumeId);
            fileSystemIdentity(model.fileSystemIdentity);
        }

        public final String getVolumeId() {
            return volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final OntapFileSystemIdentity.Builder getFileSystemIdentity() {
            return fileSystemIdentity != null ? fileSystemIdentity.toBuilder() : null;
        }

        public final void setFileSystemIdentity(OntapFileSystemIdentity.BuilderImpl fileSystemIdentity) {
            this.fileSystemIdentity = fileSystemIdentity != null ? fileSystemIdentity.build() : null;
        }

        @Override
        public final Builder fileSystemIdentity(OntapFileSystemIdentity fileSystemIdentity) {
            this.fileSystemIdentity = fileSystemIdentity;
            return this;
        }

        @Override
        public S3AccessPointOntapConfiguration build() {
            return new S3AccessPointOntapConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
