/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Used to configure quotas that define how much storage a user or group can use on an FSx for OpenZFS volume. For more
 * information, see <a
 * href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/managing-volumes.html#volume-properties">Volume
 * properties</a> in the FSx for OpenZFS User Guide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpenZFSUserOrGroupQuota implements SdkPojo, Serializable,
        ToCopyableBuilder<OpenZFSUserOrGroupQuota.Builder, OpenZFSUserOrGroupQuota> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(OpenZFSUserOrGroupQuota::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Integer> ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Id")
            .getter(getter(OpenZFSUserOrGroupQuota::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Integer> STORAGE_CAPACITY_QUOTA_GIB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StorageCapacityQuotaGiB").getter(getter(OpenZFSUserOrGroupQuota::storageCapacityQuotaGiB))
            .setter(setter(Builder::storageCapacityQuotaGiB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageCapacityQuotaGiB").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, ID_FIELD,
            STORAGE_CAPACITY_QUOTA_GIB_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final Integer id;

    private final Integer storageCapacityQuotaGiB;

    private OpenZFSUserOrGroupQuota(BuilderImpl builder) {
        this.type = builder.type;
        this.id = builder.id;
        this.storageCapacityQuotaGiB = builder.storageCapacityQuotaGiB;
    }

    /**
     * <p>
     * Specifies whether the quota applies to a user or group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OpenZFSQuotaType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies whether the quota applies to a user or group.
     * @see OpenZFSQuotaType
     */
    public final OpenZFSQuotaType type() {
        return OpenZFSQuotaType.fromValue(type);
    }

    /**
     * <p>
     * Specifies whether the quota applies to a user or group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OpenZFSQuotaType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies whether the quota applies to a user or group.
     * @see OpenZFSQuotaType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The ID of the user or group that the quota applies to.
     * </p>
     * 
     * @return The ID of the user or group that the quota applies to.
     */
    public final Integer id() {
        return id;
    }

    /**
     * <p>
     * The user or group's storage quota, in gibibytes (GiB).
     * </p>
     * 
     * @return The user or group's storage quota, in gibibytes (GiB).
     */
    public final Integer storageCapacityQuotaGiB() {
        return storageCapacityQuotaGiB;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(storageCapacityQuotaGiB());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenZFSUserOrGroupQuota)) {
            return false;
        }
        OpenZFSUserOrGroupQuota other = (OpenZFSUserOrGroupQuota) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(id(), other.id())
                && Objects.equals(storageCapacityQuotaGiB(), other.storageCapacityQuotaGiB());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OpenZFSUserOrGroupQuota").add("Type", typeAsString()).add("Id", id())
                .add("StorageCapacityQuotaGiB", storageCapacityQuotaGiB()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "StorageCapacityQuotaGiB":
            return Optional.ofNullable(clazz.cast(storageCapacityQuotaGiB()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("Id", ID_FIELD);
        map.put("StorageCapacityQuotaGiB", STORAGE_CAPACITY_QUOTA_GIB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OpenZFSUserOrGroupQuota, T> g) {
        return obj -> g.apply((OpenZFSUserOrGroupQuota) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OpenZFSUserOrGroupQuota> {
        /**
         * <p>
         * Specifies whether the quota applies to a user or group.
         * </p>
         * 
         * @param type
         *        Specifies whether the quota applies to a user or group.
         * @see OpenZFSQuotaType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpenZFSQuotaType
         */
        Builder type(String type);

        /**
         * <p>
         * Specifies whether the quota applies to a user or group.
         * </p>
         * 
         * @param type
         *        Specifies whether the quota applies to a user or group.
         * @see OpenZFSQuotaType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpenZFSQuotaType
         */
        Builder type(OpenZFSQuotaType type);

        /**
         * <p>
         * The ID of the user or group that the quota applies to.
         * </p>
         * 
         * @param id
         *        The ID of the user or group that the quota applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(Integer id);

        /**
         * <p>
         * The user or group's storage quota, in gibibytes (GiB).
         * </p>
         * 
         * @param storageCapacityQuotaGiB
         *        The user or group's storage quota, in gibibytes (GiB).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageCapacityQuotaGiB(Integer storageCapacityQuotaGiB);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private Integer id;

        private Integer storageCapacityQuotaGiB;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenZFSUserOrGroupQuota model) {
            type(model.type);
            id(model.id);
            storageCapacityQuotaGiB(model.storageCapacityQuotaGiB);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(OpenZFSQuotaType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Integer getId() {
            return id;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        @Override
        public final Builder id(Integer id) {
            this.id = id;
            return this;
        }

        public final Integer getStorageCapacityQuotaGiB() {
            return storageCapacityQuotaGiB;
        }

        public final void setStorageCapacityQuotaGiB(Integer storageCapacityQuotaGiB) {
            this.storageCapacityQuotaGiB = storageCapacityQuotaGiB;
        }

        @Override
        public final Builder storageCapacityQuotaGiB(Integer storageCapacityQuotaGiB) {
            this.storageCapacityQuotaGiB = storageCapacityQuotaGiB;
            return this;
        }

        @Override
        public OpenZFSUserOrGroupQuota build() {
            return new OpenZFSUserOrGroupQuota(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
