/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for the Amazon FSx for OpenZFS file system.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpenZFSFileSystemConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<OpenZFSFileSystemConfiguration.Builder, OpenZFSFileSystemConfiguration> {
    private static final SdkField<Integer> AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("AutomaticBackupRetentionDays")
            .getter(getter(OpenZFSFileSystemConfiguration::automaticBackupRetentionDays))
            .setter(setter(Builder::automaticBackupRetentionDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticBackupRetentionDays")
                    .build()).build();

    private static final SdkField<Boolean> COPY_TAGS_TO_BACKUPS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CopyTagsToBackups").getter(getter(OpenZFSFileSystemConfiguration::copyTagsToBackups))
            .setter(setter(Builder::copyTagsToBackups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToBackups").build()).build();

    private static final SdkField<Boolean> COPY_TAGS_TO_VOLUMES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CopyTagsToVolumes").getter(getter(OpenZFSFileSystemConfiguration::copyTagsToVolumes))
            .setter(setter(Builder::copyTagsToVolumes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToVolumes").build()).build();

    private static final SdkField<String> DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DailyAutomaticBackupStartTime")
            .getter(getter(OpenZFSFileSystemConfiguration::dailyAutomaticBackupStartTime))
            .setter(setter(Builder::dailyAutomaticBackupStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DailyAutomaticBackupStartTime")
                    .build()).build();

    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentType").getter(getter(OpenZFSFileSystemConfiguration::deploymentTypeAsString))
            .setter(setter(Builder::deploymentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentType").build()).build();

    private static final SdkField<Integer> THROUGHPUT_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ThroughputCapacity").getter(getter(OpenZFSFileSystemConfiguration::throughputCapacity))
            .setter(setter(Builder::throughputCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThroughputCapacity").build())
            .build();

    private static final SdkField<String> WEEKLY_MAINTENANCE_START_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("WeeklyMaintenanceStartTime")
            .getter(getter(OpenZFSFileSystemConfiguration::weeklyMaintenanceStartTime))
            .setter(setter(Builder::weeklyMaintenanceStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceStartTime").build())
            .build();

    private static final SdkField<DiskIopsConfiguration> DISK_IOPS_CONFIGURATION_FIELD = SdkField
            .<DiskIopsConfiguration> builder(MarshallingType.SDK_POJO).memberName("DiskIopsConfiguration")
            .getter(getter(OpenZFSFileSystemConfiguration::diskIopsConfiguration)).setter(setter(Builder::diskIopsConfiguration))
            .constructor(DiskIopsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskIopsConfiguration").build())
            .build();

    private static final SdkField<String> ROOT_VOLUME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RootVolumeId").getter(getter(OpenZFSFileSystemConfiguration::rootVolumeId))
            .setter(setter(Builder::rootVolumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootVolumeId").build()).build();

    private static final SdkField<String> PREFERRED_SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreferredSubnetId").getter(getter(OpenZFSFileSystemConfiguration::preferredSubnetId))
            .setter(setter(Builder::preferredSubnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredSubnetId").build()).build();

    private static final SdkField<String> ENDPOINT_IP_ADDRESS_RANGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointIpAddressRange").getter(getter(OpenZFSFileSystemConfiguration::endpointIpAddressRange))
            .setter(setter(Builder::endpointIpAddressRange))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointIpAddressRange").build())
            .build();

    private static final SdkField<String> ENDPOINT_IPV6_ADDRESS_RANGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointIpv6AddressRange").getter(getter(OpenZFSFileSystemConfiguration::endpointIpv6AddressRange))
            .setter(setter(Builder::endpointIpv6AddressRange))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointIpv6AddressRange").build())
            .build();

    private static final SdkField<List<String>> ROUTE_TABLE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RouteTableIds")
            .getter(getter(OpenZFSFileSystemConfiguration::routeTableIds))
            .setter(setter(Builder::routeTableIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ENDPOINT_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointIpAddress").getter(getter(OpenZFSFileSystemConfiguration::endpointIpAddress))
            .setter(setter(Builder::endpointIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointIpAddress").build()).build();

    private static final SdkField<String> ENDPOINT_IPV6_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointIpv6Address").getter(getter(OpenZFSFileSystemConfiguration::endpointIpv6Address))
            .setter(setter(Builder::endpointIpv6Address))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointIpv6Address").build())
            .build();

    private static final SdkField<OpenZFSReadCacheConfiguration> READ_CACHE_CONFIGURATION_FIELD = SdkField
            .<OpenZFSReadCacheConfiguration> builder(MarshallingType.SDK_POJO).memberName("ReadCacheConfiguration")
            .getter(getter(OpenZFSFileSystemConfiguration::readCacheConfiguration))
            .setter(setter(Builder::readCacheConfiguration)).constructor(OpenZFSReadCacheConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadCacheConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD, COPY_TAGS_TO_BACKUPS_FIELD, COPY_TAGS_TO_VOLUMES_FIELD,
            DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD, DEPLOYMENT_TYPE_FIELD, THROUGHPUT_CAPACITY_FIELD,
            WEEKLY_MAINTENANCE_START_TIME_FIELD, DISK_IOPS_CONFIGURATION_FIELD, ROOT_VOLUME_ID_FIELD, PREFERRED_SUBNET_ID_FIELD,
            ENDPOINT_IP_ADDRESS_RANGE_FIELD, ENDPOINT_IPV6_ADDRESS_RANGE_FIELD, ROUTE_TABLE_IDS_FIELD, ENDPOINT_IP_ADDRESS_FIELD,
            ENDPOINT_IPV6_ADDRESS_FIELD, READ_CACHE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer automaticBackupRetentionDays;

    private final Boolean copyTagsToBackups;

    private final Boolean copyTagsToVolumes;

    private final String dailyAutomaticBackupStartTime;

    private final String deploymentType;

    private final Integer throughputCapacity;

    private final String weeklyMaintenanceStartTime;

    private final DiskIopsConfiguration diskIopsConfiguration;

    private final String rootVolumeId;

    private final String preferredSubnetId;

    private final String endpointIpAddressRange;

    private final String endpointIpv6AddressRange;

    private final List<String> routeTableIds;

    private final String endpointIpAddress;

    private final String endpointIpv6Address;

    private final OpenZFSReadCacheConfiguration readCacheConfiguration;

    private OpenZFSFileSystemConfiguration(BuilderImpl builder) {
        this.automaticBackupRetentionDays = builder.automaticBackupRetentionDays;
        this.copyTagsToBackups = builder.copyTagsToBackups;
        this.copyTagsToVolumes = builder.copyTagsToVolumes;
        this.dailyAutomaticBackupStartTime = builder.dailyAutomaticBackupStartTime;
        this.deploymentType = builder.deploymentType;
        this.throughputCapacity = builder.throughputCapacity;
        this.weeklyMaintenanceStartTime = builder.weeklyMaintenanceStartTime;
        this.diskIopsConfiguration = builder.diskIopsConfiguration;
        this.rootVolumeId = builder.rootVolumeId;
        this.preferredSubnetId = builder.preferredSubnetId;
        this.endpointIpAddressRange = builder.endpointIpAddressRange;
        this.endpointIpv6AddressRange = builder.endpointIpv6AddressRange;
        this.routeTableIds = builder.routeTableIds;
        this.endpointIpAddress = builder.endpointIpAddress;
        this.endpointIpv6Address = builder.endpointIpv6Address;
        this.readCacheConfiguration = builder.readCacheConfiguration;
    }

    /**
     * Returns the value of the AutomaticBackupRetentionDays property for this object.
     * 
     * @return The value of the AutomaticBackupRetentionDays property for this object.
     */
    public final Integer automaticBackupRetentionDays() {
        return automaticBackupRetentionDays;
    }

    /**
     * <p>
     * A Boolean value indicating whether tags on the file system should be copied to backups. If it's set to
     * <code>true</code>, all tags on the file system are copied to all automatic backups and any user-initiated backups
     * where the user doesn't specify any tags. If this value is <code>true</code> and you specify one or more tags,
     * only the specified tags are copied to backups. If you specify one or more tags when creating a user-initiated
     * backup, no tags are copied from the file system, regardless of this value.
     * </p>
     * 
     * @return A Boolean value indicating whether tags on the file system should be copied to backups. If it's set to
     *         <code>true</code>, all tags on the file system are copied to all automatic backups and any user-initiated
     *         backups where the user doesn't specify any tags. If this value is <code>true</code> and you specify one
     *         or more tags, only the specified tags are copied to backups. If you specify one or more tags when
     *         creating a user-initiated backup, no tags are copied from the file system, regardless of this value.
     */
    public final Boolean copyTagsToBackups() {
        return copyTagsToBackups;
    }

    /**
     * <p>
     * A Boolean value indicating whether tags for the volume should be copied to snapshots. This value defaults to
     * <code>false</code>. If it's set to <code>true</code>, all tags for the volume are copied to snapshots where the
     * user doesn't specify tags. If this value is <code>true</code> and you specify one or more tags, only the
     * specified tags are copied to snapshots. If you specify one or more tags when creating the snapshot, no tags are
     * copied from the volume, regardless of this value.
     * </p>
     * 
     * @return A Boolean value indicating whether tags for the volume should be copied to snapshots. This value defaults
     *         to <code>false</code>. If it's set to <code>true</code>, all tags for the volume are copied to snapshots
     *         where the user doesn't specify tags. If this value is <code>true</code> and you specify one or more tags,
     *         only the specified tags are copied to snapshots. If you specify one or more tags when creating the
     *         snapshot, no tags are copied from the volume, regardless of this value.
     */
    public final Boolean copyTagsToVolumes() {
        return copyTagsToVolumes;
    }

    /**
     * Returns the value of the DailyAutomaticBackupStartTime property for this object.
     * 
     * @return The value of the DailyAutomaticBackupStartTime property for this object.
     */
    public final String dailyAutomaticBackupStartTime() {
        return dailyAutomaticBackupStartTime;
    }

    /**
     * <p>
     * Specifies the file-system deployment type. Amazon FSx for OpenZFS supports&#x2028; <code>MULTI_AZ_1</code>,
     * <code>SINGLE_AZ_HA_2</code>, <code>SINGLE_AZ_HA_1</code>, <code>SINGLE_AZ_2</code>, and <code>SINGLE_AZ_1</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link OpenZFSDeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return Specifies the file-system deployment type. Amazon FSx for OpenZFS supports&#x2028;
     *         <code>MULTI_AZ_1</code>, <code>SINGLE_AZ_HA_2</code>, <code>SINGLE_AZ_HA_1</code>,
     *         <code>SINGLE_AZ_2</code>, and <code>SINGLE_AZ_1</code>.
     * @see OpenZFSDeploymentType
     */
    public final OpenZFSDeploymentType deploymentType() {
        return OpenZFSDeploymentType.fromValue(deploymentType);
    }

    /**
     * <p>
     * Specifies the file-system deployment type. Amazon FSx for OpenZFS supports&#x2028; <code>MULTI_AZ_1</code>,
     * <code>SINGLE_AZ_HA_2</code>, <code>SINGLE_AZ_HA_1</code>, <code>SINGLE_AZ_2</code>, and <code>SINGLE_AZ_1</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link OpenZFSDeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return Specifies the file-system deployment type. Amazon FSx for OpenZFS supports&#x2028;
     *         <code>MULTI_AZ_1</code>, <code>SINGLE_AZ_HA_2</code>, <code>SINGLE_AZ_HA_1</code>,
     *         <code>SINGLE_AZ_2</code>, and <code>SINGLE_AZ_1</code>.
     * @see OpenZFSDeploymentType
     */
    public final String deploymentTypeAsString() {
        return deploymentType;
    }

    /**
     * <p>
     * The throughput of an Amazon FSx file system, measured in megabytes per second (MBps).
     * </p>
     * 
     * @return The throughput of an Amazon FSx file system, measured in megabytes per second (MBps).
     */
    public final Integer throughputCapacity() {
        return throughputCapacity;
    }

    /**
     * Returns the value of the WeeklyMaintenanceStartTime property for this object.
     * 
     * @return The value of the WeeklyMaintenanceStartTime property for this object.
     */
    public final String weeklyMaintenanceStartTime() {
        return weeklyMaintenanceStartTime;
    }

    /**
     * Returns the value of the DiskIopsConfiguration property for this object.
     * 
     * @return The value of the DiskIopsConfiguration property for this object.
     */
    public final DiskIopsConfiguration diskIopsConfiguration() {
        return diskIopsConfiguration;
    }

    /**
     * <p>
     * The ID of the root volume of the OpenZFS file system.
     * </p>
     * 
     * @return The ID of the root volume of the OpenZFS file system.
     */
    public final String rootVolumeId() {
        return rootVolumeId;
    }

    /**
     * <p>
     * Required when <code>DeploymentType</code> is set to <code>MULTI_AZ_1</code>. This specifies the subnet in which
     * you want the preferred file server to be located.
     * </p>
     * 
     * @return Required when <code>DeploymentType</code> is set to <code>MULTI_AZ_1</code>. This specifies the subnet in
     *         which you want the preferred file server to be located.
     */
    public final String preferredSubnetId() {
        return preferredSubnetId;
    }

    /**
     * <p>
     * (Multi-AZ only) Specifies the IPv4 address range in which the endpoints to access your file system will be
     * created. By default in the Amazon FSx API and Amazon FSx console, Amazon FSx selects an available /28 IP address
     * range for you from one of the VPC's CIDR ranges. You can have overlapping endpoint IP addresses for file systems
     * deployed in the same VPC/route tables.
     * </p>
     * 
     * @return (Multi-AZ only) Specifies the IPv4 address range in which the endpoints to access your file system will
     *         be created. By default in the Amazon FSx API and Amazon FSx console, Amazon FSx selects an available /28
     *         IP address range for you from one of the VPC's CIDR ranges. You can have overlapping endpoint IP
     *         addresses for file systems deployed in the same VPC/route tables.
     */
    public final String endpointIpAddressRange() {
        return endpointIpAddressRange;
    }

    /**
     * <p>
     * (Multi-AZ only) Specifies the IPv6 address range in which the endpoints to access your file system will be
     * created. By default in the Amazon FSx API and Amazon FSx console, Amazon FSx selects an available /118 IP address
     * range for you from one of the VPC's CIDR ranges. You can have overlapping endpoint IP addresses for file systems
     * deployed in the same VPC/route tables, as long as they don't overlap with any subnet.
     * </p>
     * 
     * @return (Multi-AZ only) Specifies the IPv6 address range in which the endpoints to access your file system will
     *         be created. By default in the Amazon FSx API and Amazon FSx console, Amazon FSx selects an available /118
     *         IP address range for you from one of the VPC's CIDR ranges. You can have overlapping endpoint IP
     *         addresses for file systems deployed in the same VPC/route tables, as long as they don't overlap with any
     *         subnet.
     */
    public final String endpointIpv6AddressRange() {
        return endpointIpv6AddressRange;
    }

    /**
     * For responses, this returns true if the service returned a value for the RouteTableIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRouteTableIds() {
        return routeTableIds != null && !(routeTableIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Multi-AZ only) The VPC route tables in which your file system's endpoints are created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRouteTableIds} method.
     * </p>
     * 
     * @return (Multi-AZ only) The VPC route tables in which your file system's endpoints are created.
     */
    public final List<String> routeTableIds() {
        return routeTableIds;
    }

    /**
     * <p>
     * The IPv4 address of the endpoint that is used to access data or to manage the file system.
     * </p>
     * 
     * @return The IPv4 address of the endpoint that is used to access data or to manage the file system.
     */
    public final String endpointIpAddress() {
        return endpointIpAddress;
    }

    /**
     * <p>
     * The IPv6 address of the endpoint that is used to access data or to manage the file system.
     * </p>
     * 
     * @return The IPv6 address of the endpoint that is used to access data or to manage the file system.
     */
    public final String endpointIpv6Address() {
        return endpointIpv6Address;
    }

    /**
     * <p>
     * Required when <code>StorageType</code> is set to <code>INTELLIGENT_TIERING</code>. Specifies the optional
     * provisioned SSD read cache.
     * </p>
     * 
     * @return Required when <code>StorageType</code> is set to <code>INTELLIGENT_TIERING</code>. Specifies the optional
     *         provisioned SSD read cache.
     */
    public final OpenZFSReadCacheConfiguration readCacheConfiguration() {
        return readCacheConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(automaticBackupRetentionDays());
        hashCode = 31 * hashCode + Objects.hashCode(copyTagsToBackups());
        hashCode = 31 * hashCode + Objects.hashCode(copyTagsToVolumes());
        hashCode = 31 * hashCode + Objects.hashCode(dailyAutomaticBackupStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(throughputCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(weeklyMaintenanceStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(diskIopsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(rootVolumeId());
        hashCode = 31 * hashCode + Objects.hashCode(preferredSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(endpointIpAddressRange());
        hashCode = 31 * hashCode + Objects.hashCode(endpointIpv6AddressRange());
        hashCode = 31 * hashCode + Objects.hashCode(hasRouteTableIds() ? routeTableIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(endpointIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(endpointIpv6Address());
        hashCode = 31 * hashCode + Objects.hashCode(readCacheConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenZFSFileSystemConfiguration)) {
            return false;
        }
        OpenZFSFileSystemConfiguration other = (OpenZFSFileSystemConfiguration) obj;
        return Objects.equals(automaticBackupRetentionDays(), other.automaticBackupRetentionDays())
                && Objects.equals(copyTagsToBackups(), other.copyTagsToBackups())
                && Objects.equals(copyTagsToVolumes(), other.copyTagsToVolumes())
                && Objects.equals(dailyAutomaticBackupStartTime(), other.dailyAutomaticBackupStartTime())
                && Objects.equals(deploymentTypeAsString(), other.deploymentTypeAsString())
                && Objects.equals(throughputCapacity(), other.throughputCapacity())
                && Objects.equals(weeklyMaintenanceStartTime(), other.weeklyMaintenanceStartTime())
                && Objects.equals(diskIopsConfiguration(), other.diskIopsConfiguration())
                && Objects.equals(rootVolumeId(), other.rootVolumeId())
                && Objects.equals(preferredSubnetId(), other.preferredSubnetId())
                && Objects.equals(endpointIpAddressRange(), other.endpointIpAddressRange())
                && Objects.equals(endpointIpv6AddressRange(), other.endpointIpv6AddressRange())
                && hasRouteTableIds() == other.hasRouteTableIds() && Objects.equals(routeTableIds(), other.routeTableIds())
                && Objects.equals(endpointIpAddress(), other.endpointIpAddress())
                && Objects.equals(endpointIpv6Address(), other.endpointIpv6Address())
                && Objects.equals(readCacheConfiguration(), other.readCacheConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OpenZFSFileSystemConfiguration")
                .add("AutomaticBackupRetentionDays", automaticBackupRetentionDays())
                .add("CopyTagsToBackups", copyTagsToBackups()).add("CopyTagsToVolumes", copyTagsToVolumes())
                .add("DailyAutomaticBackupStartTime", dailyAutomaticBackupStartTime())
                .add("DeploymentType", deploymentTypeAsString()).add("ThroughputCapacity", throughputCapacity())
                .add("WeeklyMaintenanceStartTime", weeklyMaintenanceStartTime())
                .add("DiskIopsConfiguration", diskIopsConfiguration()).add("RootVolumeId", rootVolumeId())
                .add("PreferredSubnetId", preferredSubnetId()).add("EndpointIpAddressRange", endpointIpAddressRange())
                .add("EndpointIpv6AddressRange", endpointIpv6AddressRange())
                .add("RouteTableIds", hasRouteTableIds() ? routeTableIds() : null).add("EndpointIpAddress", endpointIpAddress())
                .add("EndpointIpv6Address", endpointIpv6Address()).add("ReadCacheConfiguration", readCacheConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutomaticBackupRetentionDays":
            return Optional.ofNullable(clazz.cast(automaticBackupRetentionDays()));
        case "CopyTagsToBackups":
            return Optional.ofNullable(clazz.cast(copyTagsToBackups()));
        case "CopyTagsToVolumes":
            return Optional.ofNullable(clazz.cast(copyTagsToVolumes()));
        case "DailyAutomaticBackupStartTime":
            return Optional.ofNullable(clazz.cast(dailyAutomaticBackupStartTime()));
        case "DeploymentType":
            return Optional.ofNullable(clazz.cast(deploymentTypeAsString()));
        case "ThroughputCapacity":
            return Optional.ofNullable(clazz.cast(throughputCapacity()));
        case "WeeklyMaintenanceStartTime":
            return Optional.ofNullable(clazz.cast(weeklyMaintenanceStartTime()));
        case "DiskIopsConfiguration":
            return Optional.ofNullable(clazz.cast(diskIopsConfiguration()));
        case "RootVolumeId":
            return Optional.ofNullable(clazz.cast(rootVolumeId()));
        case "PreferredSubnetId":
            return Optional.ofNullable(clazz.cast(preferredSubnetId()));
        case "EndpointIpAddressRange":
            return Optional.ofNullable(clazz.cast(endpointIpAddressRange()));
        case "EndpointIpv6AddressRange":
            return Optional.ofNullable(clazz.cast(endpointIpv6AddressRange()));
        case "RouteTableIds":
            return Optional.ofNullable(clazz.cast(routeTableIds()));
        case "EndpointIpAddress":
            return Optional.ofNullable(clazz.cast(endpointIpAddress()));
        case "EndpointIpv6Address":
            return Optional.ofNullable(clazz.cast(endpointIpv6Address()));
        case "ReadCacheConfiguration":
            return Optional.ofNullable(clazz.cast(readCacheConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AutomaticBackupRetentionDays", AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD);
        map.put("CopyTagsToBackups", COPY_TAGS_TO_BACKUPS_FIELD);
        map.put("CopyTagsToVolumes", COPY_TAGS_TO_VOLUMES_FIELD);
        map.put("DailyAutomaticBackupStartTime", DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD);
        map.put("DeploymentType", DEPLOYMENT_TYPE_FIELD);
        map.put("ThroughputCapacity", THROUGHPUT_CAPACITY_FIELD);
        map.put("WeeklyMaintenanceStartTime", WEEKLY_MAINTENANCE_START_TIME_FIELD);
        map.put("DiskIopsConfiguration", DISK_IOPS_CONFIGURATION_FIELD);
        map.put("RootVolumeId", ROOT_VOLUME_ID_FIELD);
        map.put("PreferredSubnetId", PREFERRED_SUBNET_ID_FIELD);
        map.put("EndpointIpAddressRange", ENDPOINT_IP_ADDRESS_RANGE_FIELD);
        map.put("EndpointIpv6AddressRange", ENDPOINT_IPV6_ADDRESS_RANGE_FIELD);
        map.put("RouteTableIds", ROUTE_TABLE_IDS_FIELD);
        map.put("EndpointIpAddress", ENDPOINT_IP_ADDRESS_FIELD);
        map.put("EndpointIpv6Address", ENDPOINT_IPV6_ADDRESS_FIELD);
        map.put("ReadCacheConfiguration", READ_CACHE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OpenZFSFileSystemConfiguration, T> g) {
        return obj -> g.apply((OpenZFSFileSystemConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OpenZFSFileSystemConfiguration> {
        /**
         * Sets the value of the AutomaticBackupRetentionDays property for this object.
         *
         * @param automaticBackupRetentionDays
         *        The new value for the AutomaticBackupRetentionDays property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automaticBackupRetentionDays(Integer automaticBackupRetentionDays);

        /**
         * <p>
         * A Boolean value indicating whether tags on the file system should be copied to backups. If it's set to
         * <code>true</code>, all tags on the file system are copied to all automatic backups and any user-initiated
         * backups where the user doesn't specify any tags. If this value is <code>true</code> and you specify one or
         * more tags, only the specified tags are copied to backups. If you specify one or more tags when creating a
         * user-initiated backup, no tags are copied from the file system, regardless of this value.
         * </p>
         * 
         * @param copyTagsToBackups
         *        A Boolean value indicating whether tags on the file system should be copied to backups. If it's set to
         *        <code>true</code>, all tags on the file system are copied to all automatic backups and any
         *        user-initiated backups where the user doesn't specify any tags. If this value is <code>true</code> and
         *        you specify one or more tags, only the specified tags are copied to backups. If you specify one or
         *        more tags when creating a user-initiated backup, no tags are copied from the file system, regardless
         *        of this value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTagsToBackups(Boolean copyTagsToBackups);

        /**
         * <p>
         * A Boolean value indicating whether tags for the volume should be copied to snapshots. This value defaults to
         * <code>false</code>. If it's set to <code>true</code>, all tags for the volume are copied to snapshots where
         * the user doesn't specify tags. If this value is <code>true</code> and you specify one or more tags, only the
         * specified tags are copied to snapshots. If you specify one or more tags when creating the snapshot, no tags
         * are copied from the volume, regardless of this value.
         * </p>
         * 
         * @param copyTagsToVolumes
         *        A Boolean value indicating whether tags for the volume should be copied to snapshots. This value
         *        defaults to <code>false</code>. If it's set to <code>true</code>, all tags for the volume are copied
         *        to snapshots where the user doesn't specify tags. If this value is <code>true</code> and you specify
         *        one or more tags, only the specified tags are copied to snapshots. If you specify one or more tags
         *        when creating the snapshot, no tags are copied from the volume, regardless of this value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTagsToVolumes(Boolean copyTagsToVolumes);

        /**
         * Sets the value of the DailyAutomaticBackupStartTime property for this object.
         *
         * @param dailyAutomaticBackupStartTime
         *        The new value for the DailyAutomaticBackupStartTime property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime);

        /**
         * <p>
         * Specifies the file-system deployment type. Amazon FSx for OpenZFS supports&#x2028; <code>MULTI_AZ_1</code>,
         * <code>SINGLE_AZ_HA_2</code>, <code>SINGLE_AZ_HA_1</code>, <code>SINGLE_AZ_2</code>, and
         * <code>SINGLE_AZ_1</code>.
         * </p>
         * 
         * @param deploymentType
         *        Specifies the file-system deployment type. Amazon FSx for OpenZFS supports&#x2028;
         *        <code>MULTI_AZ_1</code>, <code>SINGLE_AZ_HA_2</code>, <code>SINGLE_AZ_HA_1</code>,
         *        <code>SINGLE_AZ_2</code>, and <code>SINGLE_AZ_1</code>.
         * @see OpenZFSDeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpenZFSDeploymentType
         */
        Builder deploymentType(String deploymentType);

        /**
         * <p>
         * Specifies the file-system deployment type. Amazon FSx for OpenZFS supports&#x2028; <code>MULTI_AZ_1</code>,
         * <code>SINGLE_AZ_HA_2</code>, <code>SINGLE_AZ_HA_1</code>, <code>SINGLE_AZ_2</code>, and
         * <code>SINGLE_AZ_1</code>.
         * </p>
         * 
         * @param deploymentType
         *        Specifies the file-system deployment type. Amazon FSx for OpenZFS supports&#x2028;
         *        <code>MULTI_AZ_1</code>, <code>SINGLE_AZ_HA_2</code>, <code>SINGLE_AZ_HA_1</code>,
         *        <code>SINGLE_AZ_2</code>, and <code>SINGLE_AZ_1</code>.
         * @see OpenZFSDeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpenZFSDeploymentType
         */
        Builder deploymentType(OpenZFSDeploymentType deploymentType);

        /**
         * <p>
         * The throughput of an Amazon FSx file system, measured in megabytes per second (MBps).
         * </p>
         * 
         * @param throughputCapacity
         *        The throughput of an Amazon FSx file system, measured in megabytes per second (MBps).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throughputCapacity(Integer throughputCapacity);

        /**
         * Sets the value of the WeeklyMaintenanceStartTime property for this object.
         *
         * @param weeklyMaintenanceStartTime
         *        The new value for the WeeklyMaintenanceStartTime property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime);

        /**
         * Sets the value of the DiskIopsConfiguration property for this object.
         *
         * @param diskIopsConfiguration
         *        The new value for the DiskIopsConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskIopsConfiguration(DiskIopsConfiguration diskIopsConfiguration);

        /**
         * Sets the value of the DiskIopsConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DiskIopsConfiguration.Builder} avoiding
         * the need to create one manually via {@link DiskIopsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DiskIopsConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #diskIopsConfiguration(DiskIopsConfiguration)}.
         * 
         * @param diskIopsConfiguration
         *        a consumer that will call methods on {@link DiskIopsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #diskIopsConfiguration(DiskIopsConfiguration)
         */
        default Builder diskIopsConfiguration(Consumer<DiskIopsConfiguration.Builder> diskIopsConfiguration) {
            return diskIopsConfiguration(DiskIopsConfiguration.builder().applyMutation(diskIopsConfiguration).build());
        }

        /**
         * <p>
         * The ID of the root volume of the OpenZFS file system.
         * </p>
         * 
         * @param rootVolumeId
         *        The ID of the root volume of the OpenZFS file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootVolumeId(String rootVolumeId);

        /**
         * <p>
         * Required when <code>DeploymentType</code> is set to <code>MULTI_AZ_1</code>. This specifies the subnet in
         * which you want the preferred file server to be located.
         * </p>
         * 
         * @param preferredSubnetId
         *        Required when <code>DeploymentType</code> is set to <code>MULTI_AZ_1</code>. This specifies the subnet
         *        in which you want the preferred file server to be located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredSubnetId(String preferredSubnetId);

        /**
         * <p>
         * (Multi-AZ only) Specifies the IPv4 address range in which the endpoints to access your file system will be
         * created. By default in the Amazon FSx API and Amazon FSx console, Amazon FSx selects an available /28 IP
         * address range for you from one of the VPC's CIDR ranges. You can have overlapping endpoint IP addresses for
         * file systems deployed in the same VPC/route tables.
         * </p>
         * 
         * @param endpointIpAddressRange
         *        (Multi-AZ only) Specifies the IPv4 address range in which the endpoints to access your file system
         *        will be created. By default in the Amazon FSx API and Amazon FSx console, Amazon FSx selects an
         *        available /28 IP address range for you from one of the VPC's CIDR ranges. You can have overlapping
         *        endpoint IP addresses for file systems deployed in the same VPC/route tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointIpAddressRange(String endpointIpAddressRange);

        /**
         * <p>
         * (Multi-AZ only) Specifies the IPv6 address range in which the endpoints to access your file system will be
         * created. By default in the Amazon FSx API and Amazon FSx console, Amazon FSx selects an available /118 IP
         * address range for you from one of the VPC's CIDR ranges. You can have overlapping endpoint IP addresses for
         * file systems deployed in the same VPC/route tables, as long as they don't overlap with any subnet.
         * </p>
         * 
         * @param endpointIpv6AddressRange
         *        (Multi-AZ only) Specifies the IPv6 address range in which the endpoints to access your file system
         *        will be created. By default in the Amazon FSx API and Amazon FSx console, Amazon FSx selects an
         *        available /118 IP address range for you from one of the VPC's CIDR ranges. You can have overlapping
         *        endpoint IP addresses for file systems deployed in the same VPC/route tables, as long as they don't
         *        overlap with any subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointIpv6AddressRange(String endpointIpv6AddressRange);

        /**
         * <p>
         * (Multi-AZ only) The VPC route tables in which your file system's endpoints are created.
         * </p>
         * 
         * @param routeTableIds
         *        (Multi-AZ only) The VPC route tables in which your file system's endpoints are created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableIds(Collection<String> routeTableIds);

        /**
         * <p>
         * (Multi-AZ only) The VPC route tables in which your file system's endpoints are created.
         * </p>
         * 
         * @param routeTableIds
         *        (Multi-AZ only) The VPC route tables in which your file system's endpoints are created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableIds(String... routeTableIds);

        /**
         * <p>
         * The IPv4 address of the endpoint that is used to access data or to manage the file system.
         * </p>
         * 
         * @param endpointIpAddress
         *        The IPv4 address of the endpoint that is used to access data or to manage the file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointIpAddress(String endpointIpAddress);

        /**
         * <p>
         * The IPv6 address of the endpoint that is used to access data or to manage the file system.
         * </p>
         * 
         * @param endpointIpv6Address
         *        The IPv6 address of the endpoint that is used to access data or to manage the file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointIpv6Address(String endpointIpv6Address);

        /**
         * <p>
         * Required when <code>StorageType</code> is set to <code>INTELLIGENT_TIERING</code>. Specifies the optional
         * provisioned SSD read cache.
         * </p>
         * 
         * @param readCacheConfiguration
         *        Required when <code>StorageType</code> is set to <code>INTELLIGENT_TIERING</code>. Specifies the
         *        optional provisioned SSD read cache.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readCacheConfiguration(OpenZFSReadCacheConfiguration readCacheConfiguration);

        /**
         * <p>
         * Required when <code>StorageType</code> is set to <code>INTELLIGENT_TIERING</code>. Specifies the optional
         * provisioned SSD read cache.
         * </p>
         * This is a convenience method that creates an instance of the {@link OpenZFSReadCacheConfiguration.Builder}
         * avoiding the need to create one manually via {@link OpenZFSReadCacheConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpenZFSReadCacheConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #readCacheConfiguration(OpenZFSReadCacheConfiguration)}.
         * 
         * @param readCacheConfiguration
         *        a consumer that will call methods on {@link OpenZFSReadCacheConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #readCacheConfiguration(OpenZFSReadCacheConfiguration)
         */
        default Builder readCacheConfiguration(Consumer<OpenZFSReadCacheConfiguration.Builder> readCacheConfiguration) {
            return readCacheConfiguration(OpenZFSReadCacheConfiguration.builder().applyMutation(readCacheConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer automaticBackupRetentionDays;

        private Boolean copyTagsToBackups;

        private Boolean copyTagsToVolumes;

        private String dailyAutomaticBackupStartTime;

        private String deploymentType;

        private Integer throughputCapacity;

        private String weeklyMaintenanceStartTime;

        private DiskIopsConfiguration diskIopsConfiguration;

        private String rootVolumeId;

        private String preferredSubnetId;

        private String endpointIpAddressRange;

        private String endpointIpv6AddressRange;

        private List<String> routeTableIds = DefaultSdkAutoConstructList.getInstance();

        private String endpointIpAddress;

        private String endpointIpv6Address;

        private OpenZFSReadCacheConfiguration readCacheConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenZFSFileSystemConfiguration model) {
            automaticBackupRetentionDays(model.automaticBackupRetentionDays);
            copyTagsToBackups(model.copyTagsToBackups);
            copyTagsToVolumes(model.copyTagsToVolumes);
            dailyAutomaticBackupStartTime(model.dailyAutomaticBackupStartTime);
            deploymentType(model.deploymentType);
            throughputCapacity(model.throughputCapacity);
            weeklyMaintenanceStartTime(model.weeklyMaintenanceStartTime);
            diskIopsConfiguration(model.diskIopsConfiguration);
            rootVolumeId(model.rootVolumeId);
            preferredSubnetId(model.preferredSubnetId);
            endpointIpAddressRange(model.endpointIpAddressRange);
            endpointIpv6AddressRange(model.endpointIpv6AddressRange);
            routeTableIds(model.routeTableIds);
            endpointIpAddress(model.endpointIpAddress);
            endpointIpv6Address(model.endpointIpv6Address);
            readCacheConfiguration(model.readCacheConfiguration);
        }

        public final Integer getAutomaticBackupRetentionDays() {
            return automaticBackupRetentionDays;
        }

        public final void setAutomaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
        }

        @Override
        public final Builder automaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
            return this;
        }

        public final Boolean getCopyTagsToBackups() {
            return copyTagsToBackups;
        }

        public final void setCopyTagsToBackups(Boolean copyTagsToBackups) {
            this.copyTagsToBackups = copyTagsToBackups;
        }

        @Override
        public final Builder copyTagsToBackups(Boolean copyTagsToBackups) {
            this.copyTagsToBackups = copyTagsToBackups;
            return this;
        }

        public final Boolean getCopyTagsToVolumes() {
            return copyTagsToVolumes;
        }

        public final void setCopyTagsToVolumes(Boolean copyTagsToVolumes) {
            this.copyTagsToVolumes = copyTagsToVolumes;
        }

        @Override
        public final Builder copyTagsToVolumes(Boolean copyTagsToVolumes) {
            this.copyTagsToVolumes = copyTagsToVolumes;
            return this;
        }

        public final String getDailyAutomaticBackupStartTime() {
            return dailyAutomaticBackupStartTime;
        }

        public final void setDailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
        }

        @Override
        public final Builder dailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
            return this;
        }

        public final String getDeploymentType() {
            return deploymentType;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(OpenZFSDeploymentType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        public final Integer getThroughputCapacity() {
            return throughputCapacity;
        }

        public final void setThroughputCapacity(Integer throughputCapacity) {
            this.throughputCapacity = throughputCapacity;
        }

        @Override
        public final Builder throughputCapacity(Integer throughputCapacity) {
            this.throughputCapacity = throughputCapacity;
            return this;
        }

        public final String getWeeklyMaintenanceStartTime() {
            return weeklyMaintenanceStartTime;
        }

        public final void setWeeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
        }

        @Override
        public final Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
            return this;
        }

        public final DiskIopsConfiguration.Builder getDiskIopsConfiguration() {
            return diskIopsConfiguration != null ? diskIopsConfiguration.toBuilder() : null;
        }

        public final void setDiskIopsConfiguration(DiskIopsConfiguration.BuilderImpl diskIopsConfiguration) {
            this.diskIopsConfiguration = diskIopsConfiguration != null ? diskIopsConfiguration.build() : null;
        }

        @Override
        public final Builder diskIopsConfiguration(DiskIopsConfiguration diskIopsConfiguration) {
            this.diskIopsConfiguration = diskIopsConfiguration;
            return this;
        }

        public final String getRootVolumeId() {
            return rootVolumeId;
        }

        public final void setRootVolumeId(String rootVolumeId) {
            this.rootVolumeId = rootVolumeId;
        }

        @Override
        public final Builder rootVolumeId(String rootVolumeId) {
            this.rootVolumeId = rootVolumeId;
            return this;
        }

        public final String getPreferredSubnetId() {
            return preferredSubnetId;
        }

        public final void setPreferredSubnetId(String preferredSubnetId) {
            this.preferredSubnetId = preferredSubnetId;
        }

        @Override
        public final Builder preferredSubnetId(String preferredSubnetId) {
            this.preferredSubnetId = preferredSubnetId;
            return this;
        }

        public final String getEndpointIpAddressRange() {
            return endpointIpAddressRange;
        }

        public final void setEndpointIpAddressRange(String endpointIpAddressRange) {
            this.endpointIpAddressRange = endpointIpAddressRange;
        }

        @Override
        public final Builder endpointIpAddressRange(String endpointIpAddressRange) {
            this.endpointIpAddressRange = endpointIpAddressRange;
            return this;
        }

        public final String getEndpointIpv6AddressRange() {
            return endpointIpv6AddressRange;
        }

        public final void setEndpointIpv6AddressRange(String endpointIpv6AddressRange) {
            this.endpointIpv6AddressRange = endpointIpv6AddressRange;
        }

        @Override
        public final Builder endpointIpv6AddressRange(String endpointIpv6AddressRange) {
            this.endpointIpv6AddressRange = endpointIpv6AddressRange;
            return this;
        }

        public final Collection<String> getRouteTableIds() {
            if (routeTableIds instanceof SdkAutoConstructList) {
                return null;
            }
            return routeTableIds;
        }

        public final void setRouteTableIds(Collection<String> routeTableIds) {
            this.routeTableIds = RouteTableIdsCopier.copy(routeTableIds);
        }

        @Override
        public final Builder routeTableIds(Collection<String> routeTableIds) {
            this.routeTableIds = RouteTableIdsCopier.copy(routeTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeTableIds(String... routeTableIds) {
            routeTableIds(Arrays.asList(routeTableIds));
            return this;
        }

        public final String getEndpointIpAddress() {
            return endpointIpAddress;
        }

        public final void setEndpointIpAddress(String endpointIpAddress) {
            this.endpointIpAddress = endpointIpAddress;
        }

        @Override
        public final Builder endpointIpAddress(String endpointIpAddress) {
            this.endpointIpAddress = endpointIpAddress;
            return this;
        }

        public final String getEndpointIpv6Address() {
            return endpointIpv6Address;
        }

        public final void setEndpointIpv6Address(String endpointIpv6Address) {
            this.endpointIpv6Address = endpointIpv6Address;
        }

        @Override
        public final Builder endpointIpv6Address(String endpointIpv6Address) {
            this.endpointIpv6Address = endpointIpv6Address;
            return this;
        }

        public final OpenZFSReadCacheConfiguration.Builder getReadCacheConfiguration() {
            return readCacheConfiguration != null ? readCacheConfiguration.toBuilder() : null;
        }

        public final void setReadCacheConfiguration(OpenZFSReadCacheConfiguration.BuilderImpl readCacheConfiguration) {
            this.readCacheConfiguration = readCacheConfiguration != null ? readCacheConfiguration.build() : null;
        }

        @Override
        public final Builder readCacheConfiguration(OpenZFSReadCacheConfiguration readCacheConfiguration) {
            this.readCacheConfiguration = readCacheConfiguration;
            return this;
        }

        @Override
        public OpenZFSFileSystemConfiguration build() {
            return new OpenZFSFileSystemConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
