/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteVolumeRequest extends FSxRequest implements
        ToCopyableBuilder<DeleteVolumeRequest.Builder, DeleteVolumeRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(DeleteVolumeRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeId").getter(getter(DeleteVolumeRequest::volumeId)).setter(setter(Builder::volumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").build()).build();

    private static final SdkField<DeleteVolumeOntapConfiguration> ONTAP_CONFIGURATION_FIELD = SdkField
            .<DeleteVolumeOntapConfiguration> builder(MarshallingType.SDK_POJO).memberName("OntapConfiguration")
            .getter(getter(DeleteVolumeRequest::ontapConfiguration)).setter(setter(Builder::ontapConfiguration))
            .constructor(DeleteVolumeOntapConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OntapConfiguration").build())
            .build();

    private static final SdkField<DeleteVolumeOpenZFSConfiguration> OPEN_ZFS_CONFIGURATION_FIELD = SdkField
            .<DeleteVolumeOpenZFSConfiguration> builder(MarshallingType.SDK_POJO).memberName("OpenZFSConfiguration")
            .getter(getter(DeleteVolumeRequest::openZFSConfiguration)).setter(setter(Builder::openZFSConfiguration))
            .constructor(DeleteVolumeOpenZFSConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenZFSConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD,
            VOLUME_ID_FIELD, ONTAP_CONFIGURATION_FIELD, OPEN_ZFS_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientRequestToken;

    private final String volumeId;

    private final DeleteVolumeOntapConfiguration ontapConfiguration;

    private final DeleteVolumeOpenZFSConfiguration openZFSConfiguration;

    private DeleteVolumeRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.volumeId = builder.volumeId;
        this.ontapConfiguration = builder.ontapConfiguration;
        this.openZFSConfiguration = builder.openZFSConfiguration;
    }

    /**
     * Returns the value of the ClientRequestToken property for this object.
     * 
     * @return The value of the ClientRequestToken property for this object.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The ID of the volume that you are deleting.
     * </p>
     * 
     * @return The ID of the volume that you are deleting.
     */
    public final String volumeId() {
        return volumeId;
    }

    /**
     * <p>
     * For Amazon FSx for ONTAP volumes, specify whether to take a final backup of the volume and apply tags to the
     * backup. To apply tags to the backup, you must have the <code>fsx:TagResource</code> permission.
     * </p>
     * 
     * @return For Amazon FSx for ONTAP volumes, specify whether to take a final backup of the volume and apply tags to
     *         the backup. To apply tags to the backup, you must have the <code>fsx:TagResource</code> permission.
     */
    public final DeleteVolumeOntapConfiguration ontapConfiguration() {
        return ontapConfiguration;
    }

    /**
     * <p>
     * For Amazon FSx for OpenZFS volumes, specify whether to delete all child volumes and snapshots.
     * </p>
     * 
     * @return For Amazon FSx for OpenZFS volumes, specify whether to delete all child volumes and snapshots.
     */
    public final DeleteVolumeOpenZFSConfiguration openZFSConfiguration() {
        return openZFSConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(ontapConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(openZFSConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVolumeRequest)) {
            return false;
        }
        DeleteVolumeRequest other = (DeleteVolumeRequest) obj;
        return Objects.equals(clientRequestToken(), other.clientRequestToken()) && Objects.equals(volumeId(), other.volumeId())
                && Objects.equals(ontapConfiguration(), other.ontapConfiguration())
                && Objects.equals(openZFSConfiguration(), other.openZFSConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteVolumeRequest").add("ClientRequestToken", clientRequestToken())
                .add("VolumeId", volumeId()).add("OntapConfiguration", ontapConfiguration())
                .add("OpenZFSConfiguration", openZFSConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "VolumeId":
            return Optional.ofNullable(clazz.cast(volumeId()));
        case "OntapConfiguration":
            return Optional.ofNullable(clazz.cast(ontapConfiguration()));
        case "OpenZFSConfiguration":
            return Optional.ofNullable(clazz.cast(openZFSConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("VolumeId", VOLUME_ID_FIELD);
        map.put("OntapConfiguration", ONTAP_CONFIGURATION_FIELD);
        map.put("OpenZFSConfiguration", OPEN_ZFS_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteVolumeRequest, T> g) {
        return obj -> g.apply((DeleteVolumeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends FSxRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteVolumeRequest> {
        /**
         * Sets the value of the ClientRequestToken property for this object.
         *
         * @param clientRequestToken
         *        The new value for the ClientRequestToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The ID of the volume that you are deleting.
         * </p>
         * 
         * @param volumeId
         *        The ID of the volume that you are deleting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        /**
         * <p>
         * For Amazon FSx for ONTAP volumes, specify whether to take a final backup of the volume and apply tags to the
         * backup. To apply tags to the backup, you must have the <code>fsx:TagResource</code> permission.
         * </p>
         * 
         * @param ontapConfiguration
         *        For Amazon FSx for ONTAP volumes, specify whether to take a final backup of the volume and apply tags
         *        to the backup. To apply tags to the backup, you must have the <code>fsx:TagResource</code> permission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ontapConfiguration(DeleteVolumeOntapConfiguration ontapConfiguration);

        /**
         * <p>
         * For Amazon FSx for ONTAP volumes, specify whether to take a final backup of the volume and apply tags to the
         * backup. To apply tags to the backup, you must have the <code>fsx:TagResource</code> permission.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeleteVolumeOntapConfiguration.Builder}
         * avoiding the need to create one manually via {@link DeleteVolumeOntapConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeleteVolumeOntapConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #ontapConfiguration(DeleteVolumeOntapConfiguration)}.
         * 
         * @param ontapConfiguration
         *        a consumer that will call methods on {@link DeleteVolumeOntapConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ontapConfiguration(DeleteVolumeOntapConfiguration)
         */
        default Builder ontapConfiguration(Consumer<DeleteVolumeOntapConfiguration.Builder> ontapConfiguration) {
            return ontapConfiguration(DeleteVolumeOntapConfiguration.builder().applyMutation(ontapConfiguration).build());
        }

        /**
         * <p>
         * For Amazon FSx for OpenZFS volumes, specify whether to delete all child volumes and snapshots.
         * </p>
         * 
         * @param openZFSConfiguration
         *        For Amazon FSx for OpenZFS volumes, specify whether to delete all child volumes and snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openZFSConfiguration(DeleteVolumeOpenZFSConfiguration openZFSConfiguration);

        /**
         * <p>
         * For Amazon FSx for OpenZFS volumes, specify whether to delete all child volumes and snapshots.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeleteVolumeOpenZFSConfiguration.Builder}
         * avoiding the need to create one manually via {@link DeleteVolumeOpenZFSConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeleteVolumeOpenZFSConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #openZFSConfiguration(DeleteVolumeOpenZFSConfiguration)}.
         * 
         * @param openZFSConfiguration
         *        a consumer that will call methods on {@link DeleteVolumeOpenZFSConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openZFSConfiguration(DeleteVolumeOpenZFSConfiguration)
         */
        default Builder openZFSConfiguration(Consumer<DeleteVolumeOpenZFSConfiguration.Builder> openZFSConfiguration) {
            return openZFSConfiguration(DeleteVolumeOpenZFSConfiguration.builder().applyMutation(openZFSConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FSxRequest.BuilderImpl implements Builder {
        private String clientRequestToken;

        private String volumeId;

        private DeleteVolumeOntapConfiguration ontapConfiguration;

        private DeleteVolumeOpenZFSConfiguration openZFSConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVolumeRequest model) {
            super(model);
            clientRequestToken(model.clientRequestToken);
            volumeId(model.volumeId);
            ontapConfiguration(model.ontapConfiguration);
            openZFSConfiguration(model.openZFSConfiguration);
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getVolumeId() {
            return volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final DeleteVolumeOntapConfiguration.Builder getOntapConfiguration() {
            return ontapConfiguration != null ? ontapConfiguration.toBuilder() : null;
        }

        public final void setOntapConfiguration(DeleteVolumeOntapConfiguration.BuilderImpl ontapConfiguration) {
            this.ontapConfiguration = ontapConfiguration != null ? ontapConfiguration.build() : null;
        }

        @Override
        public final Builder ontapConfiguration(DeleteVolumeOntapConfiguration ontapConfiguration) {
            this.ontapConfiguration = ontapConfiguration;
            return this;
        }

        public final DeleteVolumeOpenZFSConfiguration.Builder getOpenZFSConfiguration() {
            return openZFSConfiguration != null ? openZFSConfiguration.toBuilder() : null;
        }

        public final void setOpenZFSConfiguration(DeleteVolumeOpenZFSConfiguration.BuilderImpl openZFSConfiguration) {
            this.openZFSConfiguration = openZFSConfiguration != null ? openZFSConfiguration.build() : null;
        }

        @Override
        public final Builder openZFSConfiguration(DeleteVolumeOpenZFSConfiguration openZFSConfiguration) {
            this.openZFSConfiguration = openZFSConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteVolumeRequest build() {
            return new DeleteVolumeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
