/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteStorageVirtualMachineResponse extends FSxResponse implements
        ToCopyableBuilder<DeleteStorageVirtualMachineResponse.Builder, DeleteStorageVirtualMachineResponse> {
    private static final SdkField<String> STORAGE_VIRTUAL_MACHINE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageVirtualMachineId").getter(getter(DeleteStorageVirtualMachineResponse::storageVirtualMachineId))
            .setter(setter(Builder::storageVirtualMachineId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageVirtualMachineId").build())
            .build();

    private static final SdkField<String> LIFECYCLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Lifecycle").getter(getter(DeleteStorageVirtualMachineResponse::lifecycleAsString))
            .setter(setter(Builder::lifecycle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            STORAGE_VIRTUAL_MACHINE_ID_FIELD, LIFECYCLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String storageVirtualMachineId;

    private final String lifecycle;

    private DeleteStorageVirtualMachineResponse(BuilderImpl builder) {
        super(builder);
        this.storageVirtualMachineId = builder.storageVirtualMachineId;
        this.lifecycle = builder.lifecycle;
    }

    /**
     * <p>
     * The ID of the SVM Amazon FSx is deleting.
     * </p>
     * 
     * @return The ID of the SVM Amazon FSx is deleting.
     */
    public final String storageVirtualMachineId() {
        return storageVirtualMachineId;
    }

    /**
     * <p>
     * Describes the lifecycle state of the SVM being deleted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycle} will
     * return {@link StorageVirtualMachineLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #lifecycleAsString}.
     * </p>
     * 
     * @return Describes the lifecycle state of the SVM being deleted.
     * @see StorageVirtualMachineLifecycle
     */
    public final StorageVirtualMachineLifecycle lifecycle() {
        return StorageVirtualMachineLifecycle.fromValue(lifecycle);
    }

    /**
     * <p>
     * Describes the lifecycle state of the SVM being deleted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycle} will
     * return {@link StorageVirtualMachineLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #lifecycleAsString}.
     * </p>
     * 
     * @return Describes the lifecycle state of the SVM being deleted.
     * @see StorageVirtualMachineLifecycle
     */
    public final String lifecycleAsString() {
        return lifecycle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(storageVirtualMachineId());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteStorageVirtualMachineResponse)) {
            return false;
        }
        DeleteStorageVirtualMachineResponse other = (DeleteStorageVirtualMachineResponse) obj;
        return Objects.equals(storageVirtualMachineId(), other.storageVirtualMachineId())
                && Objects.equals(lifecycleAsString(), other.lifecycleAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteStorageVirtualMachineResponse").add("StorageVirtualMachineId", storageVirtualMachineId())
                .add("Lifecycle", lifecycleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StorageVirtualMachineId":
            return Optional.ofNullable(clazz.cast(storageVirtualMachineId()));
        case "Lifecycle":
            return Optional.ofNullable(clazz.cast(lifecycleAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StorageVirtualMachineId", STORAGE_VIRTUAL_MACHINE_ID_FIELD);
        map.put("Lifecycle", LIFECYCLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteStorageVirtualMachineResponse, T> g) {
        return obj -> g.apply((DeleteStorageVirtualMachineResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends FSxResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteStorageVirtualMachineResponse> {
        /**
         * <p>
         * The ID of the SVM Amazon FSx is deleting.
         * </p>
         * 
         * @param storageVirtualMachineId
         *        The ID of the SVM Amazon FSx is deleting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageVirtualMachineId(String storageVirtualMachineId);

        /**
         * <p>
         * Describes the lifecycle state of the SVM being deleted.
         * </p>
         * 
         * @param lifecycle
         *        Describes the lifecycle state of the SVM being deleted.
         * @see StorageVirtualMachineLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageVirtualMachineLifecycle
         */
        Builder lifecycle(String lifecycle);

        /**
         * <p>
         * Describes the lifecycle state of the SVM being deleted.
         * </p>
         * 
         * @param lifecycle
         *        Describes the lifecycle state of the SVM being deleted.
         * @see StorageVirtualMachineLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageVirtualMachineLifecycle
         */
        Builder lifecycle(StorageVirtualMachineLifecycle lifecycle);
    }

    static final class BuilderImpl extends FSxResponse.BuilderImpl implements Builder {
        private String storageVirtualMachineId;

        private String lifecycle;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteStorageVirtualMachineResponse model) {
            super(model);
            storageVirtualMachineId(model.storageVirtualMachineId);
            lifecycle(model.lifecycle);
        }

        public final String getStorageVirtualMachineId() {
            return storageVirtualMachineId;
        }

        public final void setStorageVirtualMachineId(String storageVirtualMachineId) {
            this.storageVirtualMachineId = storageVirtualMachineId;
        }

        @Override
        public final Builder storageVirtualMachineId(String storageVirtualMachineId) {
            this.storageVirtualMachineId = storageVirtualMachineId;
            return this;
        }

        public final String getLifecycle() {
            return lifecycle;
        }

        public final void setLifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
        }

        @Override
        public final Builder lifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Override
        public final Builder lifecycle(StorageVirtualMachineLifecycle lifecycle) {
            this.lifecycle(lifecycle == null ? null : lifecycle.toString());
            return this;
        }

        @Override
        public DeleteStorageVirtualMachineResponse build() {
            return new DeleteStorageVirtualMachineResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
