/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.FileCacheLustreDeploymentType;
import software.amazon.awssdk.services.fsx.model.FileCacheLustreMetadataConfiguration;
import software.amazon.awssdk.services.fsx.model.LustreLogConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FileCacheLustreConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FileCacheLustreConfiguration> {
    private static final SdkField<Integer> PER_UNIT_STORAGE_THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PerUnitStorageThroughput").getter(FileCacheLustreConfiguration.getter(FileCacheLustreConfiguration::perUnitStorageThroughput)).setter(FileCacheLustreConfiguration.setter(Builder::perUnitStorageThroughput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerUnitStorageThroughput").build()}).build();
    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentType").getter(FileCacheLustreConfiguration.getter(FileCacheLustreConfiguration::deploymentTypeAsString)).setter(FileCacheLustreConfiguration.setter(Builder::deploymentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentType").build()}).build();
    private static final SdkField<String> MOUNT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MountName").getter(FileCacheLustreConfiguration.getter(FileCacheLustreConfiguration::mountName)).setter(FileCacheLustreConfiguration.setter(Builder::mountName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountName").build()}).build();
    private static final SdkField<String> WEEKLY_MAINTENANCE_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WeeklyMaintenanceStartTime").getter(FileCacheLustreConfiguration.getter(FileCacheLustreConfiguration::weeklyMaintenanceStartTime)).setter(FileCacheLustreConfiguration.setter(Builder::weeklyMaintenanceStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceStartTime").build()}).build();
    private static final SdkField<FileCacheLustreMetadataConfiguration> METADATA_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetadataConfiguration").getter(FileCacheLustreConfiguration.getter(FileCacheLustreConfiguration::metadataConfiguration)).setter(FileCacheLustreConfiguration.setter(Builder::metadataConfiguration)).constructor(FileCacheLustreMetadataConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataConfiguration").build()}).build();
    private static final SdkField<LustreLogConfiguration> LOG_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LogConfiguration").getter(FileCacheLustreConfiguration.getter(FileCacheLustreConfiguration::logConfiguration)).setter(FileCacheLustreConfiguration.setter(Builder::logConfiguration)).constructor(LustreLogConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PER_UNIT_STORAGE_THROUGHPUT_FIELD, DEPLOYMENT_TYPE_FIELD, MOUNT_NAME_FIELD, WEEKLY_MAINTENANCE_START_TIME_FIELD, METADATA_CONFIGURATION_FIELD, LOG_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FileCacheLustreConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer perUnitStorageThroughput;
    private final String deploymentType;
    private final String mountName;
    private final String weeklyMaintenanceStartTime;
    private final FileCacheLustreMetadataConfiguration metadataConfiguration;
    private final LustreLogConfiguration logConfiguration;

    private FileCacheLustreConfiguration(BuilderImpl builder) {
        this.perUnitStorageThroughput = builder.perUnitStorageThroughput;
        this.deploymentType = builder.deploymentType;
        this.mountName = builder.mountName;
        this.weeklyMaintenanceStartTime = builder.weeklyMaintenanceStartTime;
        this.metadataConfiguration = builder.metadataConfiguration;
        this.logConfiguration = builder.logConfiguration;
    }

    public final Integer perUnitStorageThroughput() {
        return this.perUnitStorageThroughput;
    }

    public final FileCacheLustreDeploymentType deploymentType() {
        return FileCacheLustreDeploymentType.fromValue(this.deploymentType);
    }

    public final String deploymentTypeAsString() {
        return this.deploymentType;
    }

    public final String mountName() {
        return this.mountName;
    }

    public final String weeklyMaintenanceStartTime() {
        return this.weeklyMaintenanceStartTime;
    }

    public final FileCacheLustreMetadataConfiguration metadataConfiguration() {
        return this.metadataConfiguration;
    }

    public final LustreLogConfiguration logConfiguration() {
        return this.logConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.perUnitStorageThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mountName());
        hashCode = 31 * hashCode + Objects.hashCode(this.weeklyMaintenanceStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.logConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileCacheLustreConfiguration)) {
            return false;
        }
        FileCacheLustreConfiguration other = (FileCacheLustreConfiguration)obj;
        return Objects.equals(this.perUnitStorageThroughput(), other.perUnitStorageThroughput()) && Objects.equals(this.deploymentTypeAsString(), other.deploymentTypeAsString()) && Objects.equals(this.mountName(), other.mountName()) && Objects.equals(this.weeklyMaintenanceStartTime(), other.weeklyMaintenanceStartTime()) && Objects.equals(this.metadataConfiguration(), other.metadataConfiguration()) && Objects.equals(this.logConfiguration(), other.logConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"FileCacheLustreConfiguration").add("PerUnitStorageThroughput", (Object)this.perUnitStorageThroughput()).add("DeploymentType", (Object)this.deploymentTypeAsString()).add("MountName", (Object)this.mountName()).add("WeeklyMaintenanceStartTime", (Object)this.weeklyMaintenanceStartTime()).add("MetadataConfiguration", (Object)this.metadataConfiguration()).add("LogConfiguration", (Object)this.logConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PerUnitStorageThroughput": {
                return Optional.ofNullable(clazz.cast(this.perUnitStorageThroughput()));
            }
            case "DeploymentType": {
                return Optional.ofNullable(clazz.cast(this.deploymentTypeAsString()));
            }
            case "MountName": {
                return Optional.ofNullable(clazz.cast(this.mountName()));
            }
            case "WeeklyMaintenanceStartTime": {
                return Optional.ofNullable(clazz.cast(this.weeklyMaintenanceStartTime()));
            }
            case "MetadataConfiguration": {
                return Optional.ofNullable(clazz.cast(this.metadataConfiguration()));
            }
            case "LogConfiguration": {
                return Optional.ofNullable(clazz.cast(this.logConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PerUnitStorageThroughput", PER_UNIT_STORAGE_THROUGHPUT_FIELD);
        map.put("DeploymentType", DEPLOYMENT_TYPE_FIELD);
        map.put("MountName", MOUNT_NAME_FIELD);
        map.put("WeeklyMaintenanceStartTime", WEEKLY_MAINTENANCE_START_TIME_FIELD);
        map.put("MetadataConfiguration", METADATA_CONFIGURATION_FIELD);
        map.put("LogConfiguration", LOG_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FileCacheLustreConfiguration, T> g) {
        return obj -> g.apply((FileCacheLustreConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer perUnitStorageThroughput;
        private String deploymentType;
        private String mountName;
        private String weeklyMaintenanceStartTime;
        private FileCacheLustreMetadataConfiguration metadataConfiguration;
        private LustreLogConfiguration logConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(FileCacheLustreConfiguration model) {
            this.perUnitStorageThroughput(model.perUnitStorageThroughput);
            this.deploymentType(model.deploymentType);
            this.mountName(model.mountName);
            this.weeklyMaintenanceStartTime(model.weeklyMaintenanceStartTime);
            this.metadataConfiguration(model.metadataConfiguration);
            this.logConfiguration(model.logConfiguration);
        }

        public final Integer getPerUnitStorageThroughput() {
            return this.perUnitStorageThroughput;
        }

        public final void setPerUnitStorageThroughput(Integer perUnitStorageThroughput) {
            this.perUnitStorageThroughput = perUnitStorageThroughput;
        }

        @Override
        public final Builder perUnitStorageThroughput(Integer perUnitStorageThroughput) {
            this.perUnitStorageThroughput = perUnitStorageThroughput;
            return this;
        }

        public final String getDeploymentType() {
            return this.deploymentType;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(FileCacheLustreDeploymentType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        public final String getMountName() {
            return this.mountName;
        }

        public final void setMountName(String mountName) {
            this.mountName = mountName;
        }

        @Override
        public final Builder mountName(String mountName) {
            this.mountName = mountName;
            return this;
        }

        public final String getWeeklyMaintenanceStartTime() {
            return this.weeklyMaintenanceStartTime;
        }

        public final void setWeeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
        }

        @Override
        public final Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
            return this;
        }

        public final FileCacheLustreMetadataConfiguration.Builder getMetadataConfiguration() {
            return this.metadataConfiguration != null ? this.metadataConfiguration.toBuilder() : null;
        }

        public final void setMetadataConfiguration(FileCacheLustreMetadataConfiguration.BuilderImpl metadataConfiguration) {
            this.metadataConfiguration = metadataConfiguration != null ? metadataConfiguration.build() : null;
        }

        @Override
        public final Builder metadataConfiguration(FileCacheLustreMetadataConfiguration metadataConfiguration) {
            this.metadataConfiguration = metadataConfiguration;
            return this;
        }

        public final LustreLogConfiguration.Builder getLogConfiguration() {
            return this.logConfiguration != null ? this.logConfiguration.toBuilder() : null;
        }

        public final void setLogConfiguration(LustreLogConfiguration.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        @Override
        public final Builder logConfiguration(LustreLogConfiguration logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        public FileCacheLustreConfiguration build() {
            return new FileCacheLustreConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FileCacheLustreConfiguration> {
        public Builder perUnitStorageThroughput(Integer var1);

        public Builder deploymentType(String var1);

        public Builder deploymentType(FileCacheLustreDeploymentType var1);

        public Builder mountName(String var1);

        public Builder weeklyMaintenanceStartTime(String var1);

        public Builder metadataConfiguration(FileCacheLustreMetadataConfiguration var1);

        default public Builder metadataConfiguration(Consumer<FileCacheLustreMetadataConfiguration.Builder> metadataConfiguration) {
            return this.metadataConfiguration((FileCacheLustreMetadataConfiguration)((FileCacheLustreMetadataConfiguration.Builder)FileCacheLustreMetadataConfiguration.builder().applyMutation(metadataConfiguration)).build());
        }

        public Builder logConfiguration(LustreLogConfiguration var1);

        default public Builder logConfiguration(Consumer<LustreLogConfiguration.Builder> logConfiguration) {
            return this.logConfiguration((LustreLogConfiguration)((LustreLogConfiguration.Builder)LustreLogConfiguration.builder().applyMutation(logConfiguration)).build());
        }
    }
}

