/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.AdministrativeAction;
import software.amazon.awssdk.services.fsx.model.AdministrativeActionsCopier;
import software.amazon.awssdk.services.fsx.model.FSxResponse;
import software.amazon.awssdk.services.fsx.model.VolumeLifecycle;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreVolumeFromSnapshotResponse
extends FSxResponse
implements ToCopyableBuilder<Builder, RestoreVolumeFromSnapshotResponse> {
    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeId").getter(RestoreVolumeFromSnapshotResponse.getter(RestoreVolumeFromSnapshotResponse::volumeId)).setter(RestoreVolumeFromSnapshotResponse.setter(Builder::volumeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").build()}).build();
    private static final SdkField<String> LIFECYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Lifecycle").getter(RestoreVolumeFromSnapshotResponse.getter(RestoreVolumeFromSnapshotResponse::lifecycleAsString)).setter(RestoreVolumeFromSnapshotResponse.setter(Builder::lifecycle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()}).build();
    private static final SdkField<List<AdministrativeAction>> ADMINISTRATIVE_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdministrativeActions").getter(RestoreVolumeFromSnapshotResponse.getter(RestoreVolumeFromSnapshotResponse::administrativeActions)).setter(RestoreVolumeFromSnapshotResponse.setter(Builder::administrativeActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdministrativeActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AdministrativeAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_ID_FIELD, LIFECYCLE_FIELD, ADMINISTRATIVE_ACTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RestoreVolumeFromSnapshotResponse.memberNameToFieldInitializer();
    private final String volumeId;
    private final String lifecycle;
    private final List<AdministrativeAction> administrativeActions;

    private RestoreVolumeFromSnapshotResponse(BuilderImpl builder) {
        super(builder);
        this.volumeId = builder.volumeId;
        this.lifecycle = builder.lifecycle;
        this.administrativeActions = builder.administrativeActions;
    }

    public final String volumeId() {
        return this.volumeId;
    }

    public final VolumeLifecycle lifecycle() {
        return VolumeLifecycle.fromValue(this.lifecycle);
    }

    public final String lifecycleAsString() {
        return this.lifecycle;
    }

    public final boolean hasAdministrativeActions() {
        return this.administrativeActions != null && !(this.administrativeActions instanceof SdkAutoConstructList);
    }

    public final List<AdministrativeAction> administrativeActions() {
        return this.administrativeActions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdministrativeActions() ? this.administrativeActions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreVolumeFromSnapshotResponse)) {
            return false;
        }
        RestoreVolumeFromSnapshotResponse other = (RestoreVolumeFromSnapshotResponse)((Object)obj);
        return Objects.equals(this.volumeId(), other.volumeId()) && Objects.equals(this.lifecycleAsString(), other.lifecycleAsString()) && this.hasAdministrativeActions() == other.hasAdministrativeActions() && Objects.equals(this.administrativeActions(), other.administrativeActions());
    }

    public final String toString() {
        return ToString.builder((String)"RestoreVolumeFromSnapshotResponse").add("VolumeId", (Object)this.volumeId()).add("Lifecycle", (Object)this.lifecycleAsString()).add("AdministrativeActions", this.hasAdministrativeActions() ? this.administrativeActions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VolumeId": {
                return Optional.ofNullable(clazz.cast(this.volumeId()));
            }
            case "Lifecycle": {
                return Optional.ofNullable(clazz.cast(this.lifecycleAsString()));
            }
            case "AdministrativeActions": {
                return Optional.ofNullable(clazz.cast(this.administrativeActions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VolumeId", VOLUME_ID_FIELD);
        map.put("Lifecycle", LIFECYCLE_FIELD);
        map.put("AdministrativeActions", ADMINISTRATIVE_ACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RestoreVolumeFromSnapshotResponse, T> g) {
        return obj -> g.apply((RestoreVolumeFromSnapshotResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FSxResponse.BuilderImpl
    implements Builder {
        private String volumeId;
        private String lifecycle;
        private List<AdministrativeAction> administrativeActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreVolumeFromSnapshotResponse model) {
            super(model);
            this.volumeId(model.volumeId);
            this.lifecycle(model.lifecycle);
            this.administrativeActions(model.administrativeActions);
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final String getLifecycle() {
            return this.lifecycle;
        }

        public final void setLifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
        }

        @Override
        public final Builder lifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Override
        public final Builder lifecycle(VolumeLifecycle lifecycle) {
            this.lifecycle(lifecycle == null ? null : lifecycle.toString());
            return this;
        }

        public final List<AdministrativeAction.Builder> getAdministrativeActions() {
            List<AdministrativeAction.Builder> result = AdministrativeActionsCopier.copyToBuilder(this.administrativeActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdministrativeActions(Collection<AdministrativeAction.BuilderImpl> administrativeActions) {
            this.administrativeActions = AdministrativeActionsCopier.copyFromBuilder(administrativeActions);
        }

        @Override
        public final Builder administrativeActions(Collection<AdministrativeAction> administrativeActions) {
            this.administrativeActions = AdministrativeActionsCopier.copy(administrativeActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder administrativeActions(AdministrativeAction ... administrativeActions) {
            this.administrativeActions(Arrays.asList(administrativeActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder administrativeActions(Consumer<AdministrativeAction.Builder> ... administrativeActions) {
            this.administrativeActions(Stream.of(administrativeActions).map(c -> (AdministrativeAction)((AdministrativeAction.Builder)AdministrativeAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public RestoreVolumeFromSnapshotResponse build() {
            return new RestoreVolumeFromSnapshotResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends FSxResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RestoreVolumeFromSnapshotResponse> {
        public Builder volumeId(String var1);

        public Builder lifecycle(String var1);

        public Builder lifecycle(VolumeLifecycle var1);

        public Builder administrativeActions(Collection<AdministrativeAction> var1);

        public Builder administrativeActions(AdministrativeAction ... var1);

        public Builder administrativeActions(Consumer<AdministrativeAction.Builder> ... var1);
    }
}

