/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.DiskIopsConfiguration;
import software.amazon.awssdk.services.fsx.model.RouteTableIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFileSystemOntapConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateFileSystemOntapConfiguration> {
    private static final SdkField<Integer> AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AutomaticBackupRetentionDays").getter(UpdateFileSystemOntapConfiguration.getter(UpdateFileSystemOntapConfiguration::automaticBackupRetentionDays)).setter(UpdateFileSystemOntapConfiguration.setter(Builder::automaticBackupRetentionDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticBackupRetentionDays").build()}).build();
    private static final SdkField<String> DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DailyAutomaticBackupStartTime").getter(UpdateFileSystemOntapConfiguration.getter(UpdateFileSystemOntapConfiguration::dailyAutomaticBackupStartTime)).setter(UpdateFileSystemOntapConfiguration.setter(Builder::dailyAutomaticBackupStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DailyAutomaticBackupStartTime").build()}).build();
    private static final SdkField<String> FSX_ADMIN_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FsxAdminPassword").getter(UpdateFileSystemOntapConfiguration.getter(UpdateFileSystemOntapConfiguration::fsxAdminPassword)).setter(UpdateFileSystemOntapConfiguration.setter(Builder::fsxAdminPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FsxAdminPassword").build()}).build();
    private static final SdkField<String> WEEKLY_MAINTENANCE_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WeeklyMaintenanceStartTime").getter(UpdateFileSystemOntapConfiguration.getter(UpdateFileSystemOntapConfiguration::weeklyMaintenanceStartTime)).setter(UpdateFileSystemOntapConfiguration.setter(Builder::weeklyMaintenanceStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceStartTime").build()}).build();
    private static final SdkField<DiskIopsConfiguration> DISK_IOPS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DiskIopsConfiguration").getter(UpdateFileSystemOntapConfiguration.getter(UpdateFileSystemOntapConfiguration::diskIopsConfiguration)).setter(UpdateFileSystemOntapConfiguration.setter(Builder::diskIopsConfiguration)).constructor(DiskIopsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskIopsConfiguration").build()}).build();
    private static final SdkField<Integer> THROUGHPUT_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ThroughputCapacity").getter(UpdateFileSystemOntapConfiguration.getter(UpdateFileSystemOntapConfiguration::throughputCapacity)).setter(UpdateFileSystemOntapConfiguration.setter(Builder::throughputCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThroughputCapacity").build()}).build();
    private static final SdkField<List<String>> ADD_ROUTE_TABLE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddRouteTableIds").getter(UpdateFileSystemOntapConfiguration.getter(UpdateFileSystemOntapConfiguration::addRouteTableIds)).setter(UpdateFileSystemOntapConfiguration.setter(Builder::addRouteTableIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddRouteTableIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REMOVE_ROUTE_TABLE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemoveRouteTableIds").getter(UpdateFileSystemOntapConfiguration.getter(UpdateFileSystemOntapConfiguration::removeRouteTableIds)).setter(UpdateFileSystemOntapConfiguration.setter(Builder::removeRouteTableIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveRouteTableIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> THROUGHPUT_CAPACITY_PER_HA_PAIR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ThroughputCapacityPerHAPair").getter(UpdateFileSystemOntapConfiguration.getter(UpdateFileSystemOntapConfiguration::throughputCapacityPerHAPair)).setter(UpdateFileSystemOntapConfiguration.setter(Builder::throughputCapacityPerHAPair)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThroughputCapacityPerHAPair").build()}).build();
    private static final SdkField<Integer> HA_PAIRS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HAPairs").getter(UpdateFileSystemOntapConfiguration.getter(UpdateFileSystemOntapConfiguration::haPairs)).setter(UpdateFileSystemOntapConfiguration.setter(Builder::haPairs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HAPairs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD, DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD, FSX_ADMIN_PASSWORD_FIELD, WEEKLY_MAINTENANCE_START_TIME_FIELD, DISK_IOPS_CONFIGURATION_FIELD, THROUGHPUT_CAPACITY_FIELD, ADD_ROUTE_TABLE_IDS_FIELD, REMOVE_ROUTE_TABLE_IDS_FIELD, THROUGHPUT_CAPACITY_PER_HA_PAIR_FIELD, HA_PAIRS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer automaticBackupRetentionDays;
    private final String dailyAutomaticBackupStartTime;
    private final String fsxAdminPassword;
    private final String weeklyMaintenanceStartTime;
    private final DiskIopsConfiguration diskIopsConfiguration;
    private final Integer throughputCapacity;
    private final List<String> addRouteTableIds;
    private final List<String> removeRouteTableIds;
    private final Integer throughputCapacityPerHAPair;
    private final Integer haPairs;

    private UpdateFileSystemOntapConfiguration(BuilderImpl builder) {
        this.automaticBackupRetentionDays = builder.automaticBackupRetentionDays;
        this.dailyAutomaticBackupStartTime = builder.dailyAutomaticBackupStartTime;
        this.fsxAdminPassword = builder.fsxAdminPassword;
        this.weeklyMaintenanceStartTime = builder.weeklyMaintenanceStartTime;
        this.diskIopsConfiguration = builder.diskIopsConfiguration;
        this.throughputCapacity = builder.throughputCapacity;
        this.addRouteTableIds = builder.addRouteTableIds;
        this.removeRouteTableIds = builder.removeRouteTableIds;
        this.throughputCapacityPerHAPair = builder.throughputCapacityPerHAPair;
        this.haPairs = builder.haPairs;
    }

    public final Integer automaticBackupRetentionDays() {
        return this.automaticBackupRetentionDays;
    }

    public final String dailyAutomaticBackupStartTime() {
        return this.dailyAutomaticBackupStartTime;
    }

    public final String fsxAdminPassword() {
        return this.fsxAdminPassword;
    }

    public final String weeklyMaintenanceStartTime() {
        return this.weeklyMaintenanceStartTime;
    }

    public final DiskIopsConfiguration diskIopsConfiguration() {
        return this.diskIopsConfiguration;
    }

    public final Integer throughputCapacity() {
        return this.throughputCapacity;
    }

    public final boolean hasAddRouteTableIds() {
        return this.addRouteTableIds != null && !(this.addRouteTableIds instanceof SdkAutoConstructList);
    }

    public final List<String> addRouteTableIds() {
        return this.addRouteTableIds;
    }

    public final boolean hasRemoveRouteTableIds() {
        return this.removeRouteTableIds != null && !(this.removeRouteTableIds instanceof SdkAutoConstructList);
    }

    public final List<String> removeRouteTableIds() {
        return this.removeRouteTableIds;
    }

    public final Integer throughputCapacityPerHAPair() {
        return this.throughputCapacityPerHAPair;
    }

    public final Integer haPairs() {
        return this.haPairs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.automaticBackupRetentionDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.dailyAutomaticBackupStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.fsxAdminPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.weeklyMaintenanceStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.diskIopsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.throughputCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddRouteTableIds() ? this.addRouteTableIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoveRouteTableIds() ? this.removeRouteTableIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.throughputCapacityPerHAPair());
        hashCode = 31 * hashCode + Objects.hashCode(this.haPairs());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFileSystemOntapConfiguration)) {
            return false;
        }
        UpdateFileSystemOntapConfiguration other = (UpdateFileSystemOntapConfiguration)obj;
        return Objects.equals(this.automaticBackupRetentionDays(), other.automaticBackupRetentionDays()) && Objects.equals(this.dailyAutomaticBackupStartTime(), other.dailyAutomaticBackupStartTime()) && Objects.equals(this.fsxAdminPassword(), other.fsxAdminPassword()) && Objects.equals(this.weeklyMaintenanceStartTime(), other.weeklyMaintenanceStartTime()) && Objects.equals(this.diskIopsConfiguration(), other.diskIopsConfiguration()) && Objects.equals(this.throughputCapacity(), other.throughputCapacity()) && this.hasAddRouteTableIds() == other.hasAddRouteTableIds() && Objects.equals(this.addRouteTableIds(), other.addRouteTableIds()) && this.hasRemoveRouteTableIds() == other.hasRemoveRouteTableIds() && Objects.equals(this.removeRouteTableIds(), other.removeRouteTableIds()) && Objects.equals(this.throughputCapacityPerHAPair(), other.throughputCapacityPerHAPair()) && Objects.equals(this.haPairs(), other.haPairs());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFileSystemOntapConfiguration").add("AutomaticBackupRetentionDays", (Object)this.automaticBackupRetentionDays()).add("DailyAutomaticBackupStartTime", (Object)this.dailyAutomaticBackupStartTime()).add("FsxAdminPassword", (Object)(this.fsxAdminPassword() == null ? null : "*** Sensitive Data Redacted ***")).add("WeeklyMaintenanceStartTime", (Object)this.weeklyMaintenanceStartTime()).add("DiskIopsConfiguration", (Object)this.diskIopsConfiguration()).add("ThroughputCapacity", (Object)this.throughputCapacity()).add("AddRouteTableIds", this.hasAddRouteTableIds() ? this.addRouteTableIds() : null).add("RemoveRouteTableIds", this.hasRemoveRouteTableIds() ? this.removeRouteTableIds() : null).add("ThroughputCapacityPerHAPair", (Object)this.throughputCapacityPerHAPair()).add("HAPairs", (Object)this.haPairs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutomaticBackupRetentionDays": {
                return Optional.ofNullable(clazz.cast(this.automaticBackupRetentionDays()));
            }
            case "DailyAutomaticBackupStartTime": {
                return Optional.ofNullable(clazz.cast(this.dailyAutomaticBackupStartTime()));
            }
            case "FsxAdminPassword": {
                return Optional.ofNullable(clazz.cast(this.fsxAdminPassword()));
            }
            case "WeeklyMaintenanceStartTime": {
                return Optional.ofNullable(clazz.cast(this.weeklyMaintenanceStartTime()));
            }
            case "DiskIopsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.diskIopsConfiguration()));
            }
            case "ThroughputCapacity": {
                return Optional.ofNullable(clazz.cast(this.throughputCapacity()));
            }
            case "AddRouteTableIds": {
                return Optional.ofNullable(clazz.cast(this.addRouteTableIds()));
            }
            case "RemoveRouteTableIds": {
                return Optional.ofNullable(clazz.cast(this.removeRouteTableIds()));
            }
            case "ThroughputCapacityPerHAPair": {
                return Optional.ofNullable(clazz.cast(this.throughputCapacityPerHAPair()));
            }
            case "HAPairs": {
                return Optional.ofNullable(clazz.cast(this.haPairs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFileSystemOntapConfiguration, T> g) {
        return obj -> g.apply((UpdateFileSystemOntapConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer automaticBackupRetentionDays;
        private String dailyAutomaticBackupStartTime;
        private String fsxAdminPassword;
        private String weeklyMaintenanceStartTime;
        private DiskIopsConfiguration diskIopsConfiguration;
        private Integer throughputCapacity;
        private List<String> addRouteTableIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> removeRouteTableIds = DefaultSdkAutoConstructList.getInstance();
        private Integer throughputCapacityPerHAPair;
        private Integer haPairs;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFileSystemOntapConfiguration model) {
            this.automaticBackupRetentionDays(model.automaticBackupRetentionDays);
            this.dailyAutomaticBackupStartTime(model.dailyAutomaticBackupStartTime);
            this.fsxAdminPassword(model.fsxAdminPassword);
            this.weeklyMaintenanceStartTime(model.weeklyMaintenanceStartTime);
            this.diskIopsConfiguration(model.diskIopsConfiguration);
            this.throughputCapacity(model.throughputCapacity);
            this.addRouteTableIds(model.addRouteTableIds);
            this.removeRouteTableIds(model.removeRouteTableIds);
            this.throughputCapacityPerHAPair(model.throughputCapacityPerHAPair);
            this.haPairs(model.haPairs);
        }

        public final Integer getAutomaticBackupRetentionDays() {
            return this.automaticBackupRetentionDays;
        }

        public final void setAutomaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
        }

        @Override
        public final Builder automaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
            return this;
        }

        public final String getDailyAutomaticBackupStartTime() {
            return this.dailyAutomaticBackupStartTime;
        }

        public final void setDailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
        }

        @Override
        public final Builder dailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
            return this;
        }

        public final String getFsxAdminPassword() {
            return this.fsxAdminPassword;
        }

        public final void setFsxAdminPassword(String fsxAdminPassword) {
            this.fsxAdminPassword = fsxAdminPassword;
        }

        @Override
        public final Builder fsxAdminPassword(String fsxAdminPassword) {
            this.fsxAdminPassword = fsxAdminPassword;
            return this;
        }

        public final String getWeeklyMaintenanceStartTime() {
            return this.weeklyMaintenanceStartTime;
        }

        public final void setWeeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
        }

        @Override
        public final Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
            return this;
        }

        public final DiskIopsConfiguration.Builder getDiskIopsConfiguration() {
            return this.diskIopsConfiguration != null ? this.diskIopsConfiguration.toBuilder() : null;
        }

        public final void setDiskIopsConfiguration(DiskIopsConfiguration.BuilderImpl diskIopsConfiguration) {
            this.diskIopsConfiguration = diskIopsConfiguration != null ? diskIopsConfiguration.build() : null;
        }

        @Override
        public final Builder diskIopsConfiguration(DiskIopsConfiguration diskIopsConfiguration) {
            this.diskIopsConfiguration = diskIopsConfiguration;
            return this;
        }

        public final Integer getThroughputCapacity() {
            return this.throughputCapacity;
        }

        public final void setThroughputCapacity(Integer throughputCapacity) {
            this.throughputCapacity = throughputCapacity;
        }

        @Override
        public final Builder throughputCapacity(Integer throughputCapacity) {
            this.throughputCapacity = throughputCapacity;
            return this;
        }

        public final Collection<String> getAddRouteTableIds() {
            if (this.addRouteTableIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.addRouteTableIds;
        }

        public final void setAddRouteTableIds(Collection<String> addRouteTableIds) {
            this.addRouteTableIds = RouteTableIdsCopier.copy(addRouteTableIds);
        }

        @Override
        public final Builder addRouteTableIds(Collection<String> addRouteTableIds) {
            this.addRouteTableIds = RouteTableIdsCopier.copy(addRouteTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addRouteTableIds(String ... addRouteTableIds) {
            this.addRouteTableIds(Arrays.asList(addRouteTableIds));
            return this;
        }

        public final Collection<String> getRemoveRouteTableIds() {
            if (this.removeRouteTableIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.removeRouteTableIds;
        }

        public final void setRemoveRouteTableIds(Collection<String> removeRouteTableIds) {
            this.removeRouteTableIds = RouteTableIdsCopier.copy(removeRouteTableIds);
        }

        @Override
        public final Builder removeRouteTableIds(Collection<String> removeRouteTableIds) {
            this.removeRouteTableIds = RouteTableIdsCopier.copy(removeRouteTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeRouteTableIds(String ... removeRouteTableIds) {
            this.removeRouteTableIds(Arrays.asList(removeRouteTableIds));
            return this;
        }

        public final Integer getThroughputCapacityPerHAPair() {
            return this.throughputCapacityPerHAPair;
        }

        public final void setThroughputCapacityPerHAPair(Integer throughputCapacityPerHAPair) {
            this.throughputCapacityPerHAPair = throughputCapacityPerHAPair;
        }

        @Override
        public final Builder throughputCapacityPerHAPair(Integer throughputCapacityPerHAPair) {
            this.throughputCapacityPerHAPair = throughputCapacityPerHAPair;
            return this;
        }

        public final Integer getHaPairs() {
            return this.haPairs;
        }

        public final void setHaPairs(Integer haPairs) {
            this.haPairs = haPairs;
        }

        @Override
        public final Builder haPairs(Integer haPairs) {
            this.haPairs = haPairs;
            return this;
        }

        public UpdateFileSystemOntapConfiguration build() {
            return new UpdateFileSystemOntapConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateFileSystemOntapConfiguration> {
        public Builder automaticBackupRetentionDays(Integer var1);

        public Builder dailyAutomaticBackupStartTime(String var1);

        public Builder fsxAdminPassword(String var1);

        public Builder weeklyMaintenanceStartTime(String var1);

        public Builder diskIopsConfiguration(DiskIopsConfiguration var1);

        default public Builder diskIopsConfiguration(Consumer<DiskIopsConfiguration.Builder> diskIopsConfiguration) {
            return this.diskIopsConfiguration((DiskIopsConfiguration)((DiskIopsConfiguration.Builder)DiskIopsConfiguration.builder().applyMutation(diskIopsConfiguration)).build());
        }

        public Builder throughputCapacity(Integer var1);

        public Builder addRouteTableIds(Collection<String> var1);

        public Builder addRouteTableIds(String ... var1);

        public Builder removeRouteTableIds(Collection<String> var1);

        public Builder removeRouteTableIds(String ... var1);

        public Builder throughputCapacityPerHAPair(Integer var1);

        public Builder haPairs(Integer var1);
    }
}

