/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.OpenZFSReadCacheSizingMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpenZFSReadCacheConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OpenZFSReadCacheConfiguration> {
    private static final SdkField<String> SIZING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SizingMode").getter(OpenZFSReadCacheConfiguration.getter(OpenZFSReadCacheConfiguration::sizingModeAsString)).setter(OpenZFSReadCacheConfiguration.setter(Builder::sizingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizingMode").build()}).build();
    private static final SdkField<Integer> SIZE_GIB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SizeGiB").getter(OpenZFSReadCacheConfiguration.getter(OpenZFSReadCacheConfiguration::sizeGiB)).setter(OpenZFSReadCacheConfiguration.setter(Builder::sizeGiB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeGiB").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIZING_MODE_FIELD, SIZE_GIB_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SizingMode", SIZING_MODE_FIELD);
            this.put("SizeGiB", SIZE_GIB_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String sizingMode;
    private final Integer sizeGiB;

    private OpenZFSReadCacheConfiguration(BuilderImpl builder) {
        this.sizingMode = builder.sizingMode;
        this.sizeGiB = builder.sizeGiB;
    }

    public final OpenZFSReadCacheSizingMode sizingMode() {
        return OpenZFSReadCacheSizingMode.fromValue(this.sizingMode);
    }

    public final String sizingModeAsString() {
        return this.sizingMode;
    }

    public final Integer sizeGiB() {
        return this.sizeGiB;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sizingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeGiB());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenZFSReadCacheConfiguration)) {
            return false;
        }
        OpenZFSReadCacheConfiguration other = (OpenZFSReadCacheConfiguration)obj;
        return Objects.equals(this.sizingModeAsString(), other.sizingModeAsString()) && Objects.equals(this.sizeGiB(), other.sizeGiB());
    }

    public final String toString() {
        return ToString.builder((String)"OpenZFSReadCacheConfiguration").add("SizingMode", (Object)this.sizingModeAsString()).add("SizeGiB", (Object)this.sizeGiB()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SizingMode": {
                return Optional.ofNullable(clazz.cast(this.sizingModeAsString()));
            }
            case "SizeGiB": {
                return Optional.ofNullable(clazz.cast(this.sizeGiB()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OpenZFSReadCacheConfiguration, T> g) {
        return obj -> g.apply((OpenZFSReadCacheConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sizingMode;
        private Integer sizeGiB;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenZFSReadCacheConfiguration model) {
            this.sizingMode(model.sizingMode);
            this.sizeGiB(model.sizeGiB);
        }

        public final String getSizingMode() {
            return this.sizingMode;
        }

        public final void setSizingMode(String sizingMode) {
            this.sizingMode = sizingMode;
        }

        @Override
        public final Builder sizingMode(String sizingMode) {
            this.sizingMode = sizingMode;
            return this;
        }

        @Override
        public final Builder sizingMode(OpenZFSReadCacheSizingMode sizingMode) {
            this.sizingMode(sizingMode == null ? null : sizingMode.toString());
            return this;
        }

        public final Integer getSizeGiB() {
            return this.sizeGiB;
        }

        public final void setSizeGiB(Integer sizeGiB) {
            this.sizeGiB = sizeGiB;
        }

        @Override
        public final Builder sizeGiB(Integer sizeGiB) {
            this.sizeGiB = sizeGiB;
            return this;
        }

        public OpenZFSReadCacheConfiguration build() {
            return new OpenZFSReadCacheConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OpenZFSReadCacheConfiguration> {
        public Builder sizingMode(String var1);

        public Builder sizingMode(OpenZFSReadCacheSizingMode var1);

        public Builder sizeGiB(Integer var1);
    }
}

