/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WindowsAccessAuditLogLevel {
    DISABLED("DISABLED"),
    SUCCESS_ONLY("SUCCESS_ONLY"),
    FAILURE_ONLY("FAILURE_ONLY"),
    SUCCESS_AND_FAILURE("SUCCESS_AND_FAILURE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WindowsAccessAuditLogLevel> VALUE_MAP;
    private final String value;

    private WindowsAccessAuditLogLevel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WindowsAccessAuditLogLevel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WindowsAccessAuditLogLevel> knownValues() {
        EnumSet<WindowsAccessAuditLogLevel> knownValues = EnumSet.allOf(WindowsAccessAuditLogLevel.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WindowsAccessAuditLogLevel.class, WindowsAccessAuditLogLevel::toString);
    }
}

