/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.endpoints.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.services.fsx.endpoints.FSxEndpointParams;
import software.amazon.awssdk.services.fsx.endpoints.FSxEndpointProvider;
import software.amazon.awssdk.services.fsx.endpoints.internal.AwsEndpointProviderUtils;
import software.amazon.awssdk.services.fsx.endpoints.internal.Condition;
import software.amazon.awssdk.services.fsx.endpoints.internal.DefaultRuleEngine;
import software.amazon.awssdk.services.fsx.endpoints.internal.EndpointResult;
import software.amazon.awssdk.services.fsx.endpoints.internal.EndpointRuleset;
import software.amazon.awssdk.services.fsx.endpoints.internal.Expr;
import software.amazon.awssdk.services.fsx.endpoints.internal.FnNode;
import software.amazon.awssdk.services.fsx.endpoints.internal.Identifier;
import software.amazon.awssdk.services.fsx.endpoints.internal.Parameter;
import software.amazon.awssdk.services.fsx.endpoints.internal.ParameterType;
import software.amazon.awssdk.services.fsx.endpoints.internal.Parameters;
import software.amazon.awssdk.services.fsx.endpoints.internal.Rule;
import software.amazon.awssdk.services.fsx.endpoints.internal.Value;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
public final class DefaultFSxEndpointProvider
implements FSxEndpointProvider {
    private static final EndpointRuleset ENDPOINT_RULE_SET = DefaultFSxEndpointProvider.ruleSet();

    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(FSxEndpointParams endpointParams) {
        Value res = new DefaultRuleEngine().evaluate(ENDPOINT_RULE_SET, DefaultFSxEndpointProvider.toIdentifierValueMap(endpointParams));
        try {
            return CompletableFuture.completedFuture(AwsEndpointProviderUtils.valueAsEndpointOrThrow(res));
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static Map<Identifier, Value> toIdentifierValueMap(FSxEndpointParams params) {
        HashMap<Identifier, Value> paramsMap = new HashMap<Identifier, Value>();
        if (params.region() != null) {
            paramsMap.put(Identifier.of("Region"), Value.fromStr(params.region().id()));
        }
        if (params.useDualStack() != null) {
            paramsMap.put(Identifier.of("UseDualStack"), Value.fromBool(params.useDualStack()));
        }
        if (params.useFips() != null) {
            paramsMap.put(Identifier.of("UseFIPS"), Value.fromBool(params.useFips()));
        }
        if (params.endpoint() != null) {
            paramsMap.put(Identifier.of("Endpoint"), Value.fromStr(params.endpoint()));
        }
        return paramsMap;
    }

    private static Rule endpointRule_2() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).error("Invalid Configuration: FIPS and custom endpoint are not supported");
    }

    private static Rule endpointRule_4() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).error("Invalid Configuration: Dualstack and custom endpoint are not supported");
    }

    private static Rule endpointRule_5() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.ref(Identifier.of("Endpoint"))).build());
    }

    private static Rule endpointRule_3() {
        return Rule.builder().treeRule(Arrays.asList(DefaultFSxEndpointProvider.endpointRule_4(), DefaultFSxEndpointProvider.endpointRule_5()));
    }

    private static Rule endpointRule_1() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).treeRule(Arrays.asList(DefaultFSxEndpointProvider.endpointRule_2(), DefaultFSxEndpointProvider.endpointRule_3()));
    }

    private static Rule endpointRule_8() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://fsx-fips.{Region}.{PartitionResult#dualStackDnsSuffix}")).build());
    }

    private static Rule endpointRule_7() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultFSxEndpointProvider.endpointRule_8()));
    }

    private static Rule endpointRule_9() {
        return Rule.builder().error("FIPS and DualStack are enabled, but this partition does not support one or both");
    }

    private static Rule endpointRule_6() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultFSxEndpointProvider.endpointRule_7(), DefaultFSxEndpointProvider.endpointRule_9()));
    }

    private static Rule endpointRule_13() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("prod-ca-central-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://fsx-fips.ca-central-1.amazonaws.com")).build());
    }

    private static Rule endpointRule_14() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("prod-us-east-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://fsx-fips.us-east-1.amazonaws.com")).build());
    }

    private static Rule endpointRule_15() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("prod-us-east-2"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://fsx-fips.us-east-2.amazonaws.com")).build());
    }

    private static Rule endpointRule_16() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("prod-us-west-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://fsx-fips.us-west-1.amazonaws.com")).build());
    }

    private static Rule endpointRule_17() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("prod-us-west-2"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://fsx-fips.us-west-2.amazonaws.com")).build());
    }

    private static Rule endpointRule_18() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("prod-us-gov-east-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://fsx-fips.us-gov-east-1.amazonaws.com")).build());
    }

    private static Rule endpointRule_19() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("prod-us-gov-west-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://fsx-fips.us-gov-west-1.amazonaws.com")).build());
    }

    private static Rule endpointRule_20() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://fsx-fips.{Region}.{PartitionResult#dnsSuffix}")).build());
    }

    private static Rule endpointRule_12() {
        return Rule.builder().treeRule(Arrays.asList(DefaultFSxEndpointProvider.endpointRule_13(), DefaultFSxEndpointProvider.endpointRule_14(), DefaultFSxEndpointProvider.endpointRule_15(), DefaultFSxEndpointProvider.endpointRule_16(), DefaultFSxEndpointProvider.endpointRule_17(), DefaultFSxEndpointProvider.endpointRule_18(), DefaultFSxEndpointProvider.endpointRule_19(), DefaultFSxEndpointProvider.endpointRule_20()));
    }

    private static Rule endpointRule_11() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultFSxEndpointProvider.endpointRule_12()));
    }

    private static Rule endpointRule_21() {
        return Rule.builder().error("FIPS is enabled but this partition does not support FIPS");
    }

    private static Rule endpointRule_10() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultFSxEndpointProvider.endpointRule_11(), DefaultFSxEndpointProvider.endpointRule_21()));
    }

    private static Rule endpointRule_24() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://fsx.{Region}.{PartitionResult#dualStackDnsSuffix}")).build());
    }

    private static Rule endpointRule_23() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultFSxEndpointProvider.endpointRule_24()));
    }

    private static Rule endpointRule_25() {
        return Rule.builder().error("DualStack is enabled but this partition does not support DualStack");
    }

    private static Rule endpointRule_22() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultFSxEndpointProvider.endpointRule_23(), DefaultFSxEndpointProvider.endpointRule_25()));
    }

    private static Rule endpointRule_26() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://fsx.{Region}.{PartitionResult#dnsSuffix}")).build());
    }

    private static Rule endpointRule_0() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("aws.partition").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).result("PartitionResult").build()).treeRule(Arrays.asList(DefaultFSxEndpointProvider.endpointRule_1(), DefaultFSxEndpointProvider.endpointRule_6(), DefaultFSxEndpointProvider.endpointRule_10(), DefaultFSxEndpointProvider.endpointRule_22(), DefaultFSxEndpointProvider.endpointRule_26()));
    }

    private static EndpointRuleset ruleSet() {
        return EndpointRuleset.builder().version("1.0").serviceId(null).parameters(Parameters.builder().addParameter(Parameter.builder().name("Region").type(ParameterType.fromValue("String")).required(true).builtIn("AWS::Region").documentation("The AWS region used to dispatch the request.").build()).addParameter(Parameter.builder().name("UseDualStack").type(ParameterType.fromValue("Boolean")).required(true).builtIn("AWS::UseDualStack").documentation("When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.").defaultValue(Value.fromBool(false)).build()).addParameter(Parameter.builder().name("UseFIPS").type(ParameterType.fromValue("Boolean")).required(true).builtIn("AWS::UseFIPS").documentation("When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.").defaultValue(Value.fromBool(false)).build()).addParameter(Parameter.builder().name("Endpoint").type(ParameterType.fromValue("String")).required(false).builtIn("SDK::Endpoint").documentation("Override the endpoint used to send this request").build()).build()).addRule(DefaultFSxEndpointProvider.endpointRule_0()).build();
    }
}

