/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.Tag;
import software.amazon.awssdk.services.fsx.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteVolumeOntapResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeleteVolumeOntapResponse> {
    private static final SdkField<String> FINAL_BACKUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FinalBackupId").getter(DeleteVolumeOntapResponse.getter(DeleteVolumeOntapResponse::finalBackupId)).setter(DeleteVolumeOntapResponse.setter(Builder::finalBackupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalBackupId").build()}).build();
    private static final SdkField<List<Tag>> FINAL_BACKUP_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FinalBackupTags").getter(DeleteVolumeOntapResponse.getter(DeleteVolumeOntapResponse::finalBackupTags)).setter(DeleteVolumeOntapResponse.setter(Builder::finalBackupTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalBackupTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINAL_BACKUP_ID_FIELD, FINAL_BACKUP_TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String finalBackupId;
    private final List<Tag> finalBackupTags;

    private DeleteVolumeOntapResponse(BuilderImpl builder) {
        this.finalBackupId = builder.finalBackupId;
        this.finalBackupTags = builder.finalBackupTags;
    }

    public final String finalBackupId() {
        return this.finalBackupId;
    }

    public final boolean hasFinalBackupTags() {
        return this.finalBackupTags != null && !(this.finalBackupTags instanceof SdkAutoConstructList);
    }

    public final List<Tag> finalBackupTags() {
        return this.finalBackupTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.finalBackupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFinalBackupTags() ? this.finalBackupTags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVolumeOntapResponse)) {
            return false;
        }
        DeleteVolumeOntapResponse other = (DeleteVolumeOntapResponse)obj;
        return Objects.equals(this.finalBackupId(), other.finalBackupId()) && this.hasFinalBackupTags() == other.hasFinalBackupTags() && Objects.equals(this.finalBackupTags(), other.finalBackupTags());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteVolumeOntapResponse").add("FinalBackupId", (Object)this.finalBackupId()).add("FinalBackupTags", this.hasFinalBackupTags() ? this.finalBackupTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FinalBackupId": {
                return Optional.ofNullable(clazz.cast(this.finalBackupId()));
            }
            case "FinalBackupTags": {
                return Optional.ofNullable(clazz.cast(this.finalBackupTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteVolumeOntapResponse, T> g) {
        return obj -> g.apply((DeleteVolumeOntapResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String finalBackupId;
        private List<Tag> finalBackupTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVolumeOntapResponse model) {
            this.finalBackupId(model.finalBackupId);
            this.finalBackupTags(model.finalBackupTags);
        }

        public final String getFinalBackupId() {
            return this.finalBackupId;
        }

        public final void setFinalBackupId(String finalBackupId) {
            this.finalBackupId = finalBackupId;
        }

        @Override
        @Transient
        public final Builder finalBackupId(String finalBackupId) {
            this.finalBackupId = finalBackupId;
            return this;
        }

        public final List<Tag.Builder> getFinalBackupTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.finalBackupTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFinalBackupTags(Collection<Tag.BuilderImpl> finalBackupTags) {
            this.finalBackupTags = TagsCopier.copyFromBuilder(finalBackupTags);
        }

        @Override
        @Transient
        public final Builder finalBackupTags(Collection<Tag> finalBackupTags) {
            this.finalBackupTags = TagsCopier.copy(finalBackupTags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder finalBackupTags(Tag ... finalBackupTags) {
            this.finalBackupTags(Arrays.asList(finalBackupTags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder finalBackupTags(Consumer<Tag.Builder> ... finalBackupTags) {
            this.finalBackupTags(Stream.of(finalBackupTags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DeleteVolumeOntapResponse build() {
            return new DeleteVolumeOntapResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeleteVolumeOntapResponse> {
        public Builder finalBackupId(String var1);

        public Builder finalBackupTags(Collection<Tag> var1);

        public Builder finalBackupTags(Tag ... var1);

        public Builder finalBackupTags(Consumer<Tag.Builder> ... var1);
    }
}

