/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AutoImportPolicyType {
    NONE("NONE"),
    NEW("NEW"),
    NEW_CHANGED("NEW_CHANGED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AutoImportPolicyType> VALUE_MAP;
    private final String value;

    private AutoImportPolicyType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AutoImportPolicyType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AutoImportPolicyType> knownValues() {
        EnumSet<AutoImportPolicyType> knownValues = EnumSet.allOf(AutoImportPolicyType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AutoImportPolicyType.class, AutoImportPolicyType::toString);
    }
}

